Bridge.assembly("Bridge.Collections",function(){"use strict";Bridge.define("System.Collections.BitArray",{inherits:[System.Collections.ICollection,System.ICloneable],statics:{BitsPerInt32:32,BytesPerInt32:4,BitsPerByte:8,_ShrinkThreshold:256,getArrayLength:function(n,t){return n>0?(Bridge.Int.div(n-1|0,t)|0)+1|0:0}},m_array:null,m_length:0,_version:0,config:{alias:["getCount","System$Collections$ICollection$getCount","clone","System$ICloneable$clone","getIsReadOnly","System$Collections$ICollection$getIsReadOnly","getEnumerator","System$Collections$IEnumerable$getEnumerator"]},$ctor3:function(n){System.Collections.BitArray.$ctor4.call(this,n,!1)},$ctor4:function(n,t){var r,i;if(this.$initialize(),n<0)throw new System.ArgumentOutOfRangeException("length","Index is less than zero.");for(this.m_array=System.Array.init(System.Collections.BitArray.getArrayLength(n,System.Collections.BitArray.BitsPerInt32),0),this.m_length=n,r=t?-1:0,i=0;i<this.m_array.length;i=i+1|0)this.m_array[i]=r;this._version=0},$ctor1:function(n){var i,t,r;if(this.$initialize(),n==null)throw new System.ArgumentNullException("bytes");if(n.length>268435455)throw new System.ArgumentException(System.String.format("The input array length must not exceed Int32.MaxValue / {0}. Otherwise BitArray.Length would exceed Int32.MaxValue.",System.Collections.BitArray.BitsPerByte),"bytes");for(this.m_array=System.Array.init(System.Collections.BitArray.getArrayLength(n.length,System.Collections.BitArray.BytesPerInt32),0),this.m_length=n.length*System.Collections.BitArray.BitsPerByte|0,i=0,t=0;(n.length-t|0)>=4;)this.m_array[Bridge.identity(i,i=i+1|0)]=n[t]&255|(n[t+1|0]&255)<<8|(n[t+2|0]&255)<<16|(n[t+3|0]&255)<<24,t=t+4|0;r=n.length-t|0;r===3&&(this.m_array[i]=(n[t+2|0]&255)<<16,r=2);r===2&&(this.m_array[i]=this.m_array[i]|(n[t+1|0]&255)<<8,r=1);r===1&&(this.m_array[i]=this.m_array[i]|n[t]&255);this._version=0},ctor:function(n){if(this.$initialize(),n==null)throw new System.ArgumentNullException("values");this.m_array=System.Array.init(System.Collections.BitArray.getArrayLength(n.length,System.Collections.BitArray.BitsPerInt32),0);this.m_length=n.length;for(var t=0;t<n.length;t=t+1|0)n[t]&&(this.m_array[Bridge.Int.div(t,32)|0]=this.m_array[Bridge.Int.div(t,32)|0]|1<<t%32);this._version=0},$ctor5:function(n){if(this.$initialize(),n==null)throw new System.ArgumentNullException("values");if(n.length>67108863)throw new System.ArgumentException(System.String.format("The input array length must not exceed Int32.MaxValue / {0}. Otherwise BitArray.Length would exceed Int32.MaxValue.",System.Collections.BitArray.BitsPerInt32),"values");this.m_array=System.Array.init(n.length,0);this.m_length=n.length*System.Collections.BitArray.BitsPerInt32|0;System.Array.copy(n,0,this.m_array,0,n.length);this._version=0},$ctor2:function(n){if(this.$initialize(),n==null)throw new System.ArgumentNullException("bits");var t=System.Collections.BitArray.getArrayLength(n.m_length,System.Collections.BitArray.BitsPerInt32);this.m_array=System.Array.init(t,0);this.m_length=n.m_length;System.Array.copy(n.m_array,0,this.m_array,0,t);this._version=n._version},getItem:function(n){return this.get(n)},setItem:function(n,t){this.set(n,t)},getLength:function(){return this.m_length},setLength:function(n){var t,r,i,u;if(n<0)throw new System.ArgumentOutOfRangeException("value","Non-negative number required.");t=System.Collections.BitArray.getArrayLength(n,System.Collections.BitArray.BitsPerInt32);(t>this.m_array.length||(t+System.Collections.BitArray._ShrinkThreshold|0)<this.m_array.length)&&(r=System.Array.init(t,0),System.Array.copy(this.m_array,0,r,0,t>this.m_array.length?this.m_array.length:t),this.m_array=r);n>this.m_length&&(i=System.Collections.BitArray.getArrayLength(this.m_length,System.Collections.BitArray.BitsPerInt32)-1|0,u=this.m_length%32,u>0&&(this.m_array[i]=this.m_array[i]&((1<<u)-1|0)),System.Array.fill(this.m_array,0,i+1|0,(t-i|0)-1|0));this.m_length=n;this._version=this._version+1|0},getCount:function(){return this.m_length},getIsReadOnly:function(){return!1},getIsSynchronized:function(){return!1},get:function(n){if(n<0||n>=this.getLength())throw new System.ArgumentOutOfRangeException("index","Index was out of range. Must be non-negative and less than the size of the collection.");return(this.m_array[Bridge.Int.div(n,32)|0]&1<<n%32)!=0},set:function(n,t){if(n<0||n>=this.getLength())throw new System.ArgumentOutOfRangeException("index","Index was out of range. Must be non-negative and less than the size of the collection.");this.m_array[Bridge.Int.div(n,32)|0]=t?this.m_array[Bridge.Int.div(n,32)|0]|1<<n%32:this.m_array[Bridge.Int.div(n,32)|0]&~(1<<n%32);this._version=this._version+1|0},setAll:function(n){for(var i=n?-1:0,r=System.Collections.BitArray.getArrayLength(this.m_length,System.Collections.BitArray.BitsPerInt32),t=0;t<r;t=t+1|0)this.m_array[t]=i;this._version=this._version+1|0},and:function(n){var i,t;if(n==null)throw new System.ArgumentNullException("value");if(this.getLength()!==n.getLength())throw new System.ArgumentException("Array lengths must be the same.");for(i=System.Collections.BitArray.getArrayLength(this.m_length,System.Collections.BitArray.BitsPerInt32),t=0;t<i;t=t+1|0)this.m_array[t]=this.m_array[t]&n.m_array[t];return this._version=this._version+1|0,this},or:function(n){var i,t;if(n==null)throw new System.ArgumentNullException("value");if(this.getLength()!==n.getLength())throw new System.ArgumentException("Array lengths must be the same.");for(i=System.Collections.BitArray.getArrayLength(this.m_length,System.Collections.BitArray.BitsPerInt32),t=0;t<i;t=t+1|0)this.m_array[t]=this.m_array[t]|n.m_array[t];return this._version=this._version+1|0,this},xor:function(n){var i,t;if(n==null)throw new System.ArgumentNullException("value");if(this.getLength()!==n.getLength())throw new System.ArgumentException("Array lengths must be the same.");for(i=System.Collections.BitArray.getArrayLength(this.m_length,System.Collections.BitArray.BitsPerInt32),t=0;t<i;t=t+1|0)this.m_array[t]=this.m_array[t]^n.m_array[t];return this._version=this._version+1|0,this},not:function(){for(var t=System.Collections.BitArray.getArrayLength(this.m_length,System.Collections.BitArray.BitsPerInt32),n=0;n<t;n=n+1|0)this.m_array[n]=~this.m_array[n];return this._version=this._version+1|0,this},clone:function(){var n=new System.Collections.BitArray.$ctor5(this.m_array);return n._version=this._version,n.m_length=this.m_length,n},getEnumerator:function(){return new System.Collections.BitArray.BitArrayEnumeratorSimple(this)}});Bridge.define("System.Collections.BitArray.BitArrayEnumeratorSimple",{inherits:[System.Collections.IEnumerator],bitarray:null,index:0,version:0,currentElement:!1,config:{alias:["moveNext","System$Collections$IEnumerator$moveNext","getCurrent","System$Collections$IEnumerator$getCurrent","reset","System$Collections$IEnumerator$reset"]},ctor:function(n){this.$initialize();this.bitarray=n;this.index=-1;this.version=n._version},getCurrent:function(){if(this.index===-1)throw new System.InvalidOperationException("Enumeration has not started. Call MoveNext.");if(this.index>=this.bitarray.getCount())throw new System.InvalidOperationException("Enumeration already finished.");return this.currentElement},moveNext:function(){if(this.version!==this.bitarray._version)throw new System.InvalidOperationException("Collection was modified; enumeration operation may not execute.");return this.index<(this.bitarray.getCount()-1|0)?(this.index=this.index+1|0,this.currentElement=this.bitarray.get(this.index),!0):(this.index=this.bitarray.getCount(),!1)},reset:function(){if(this.version!==this.bitarray._version)throw new System.InvalidOperationException("Collection was modified; enumeration operation may not execute.");this.index=-1}});Bridge.define("System.Collections.Generic.BitHelper",{statics:{MarkedBitFlag:1,IntSize:32,toIntArrayLength:function(n){return n>0?(Bridge.Int.div(n-1|0,System.Collections.Generic.BitHelper.IntSize)|0)+1|0:0}},_length:0,_array:null,ctor:function(n,t){this.$initialize();this._array=n;this._length=t},markBit:function(n){var t=Bridge.Int.div(n,System.Collections.Generic.BitHelper.IntSize)|0,i;t<this._length&&t>=0&&(i=System.Collections.Generic.BitHelper.MarkedBitFlag<<n%System.Collections.Generic.BitHelper.IntSize,this._array[t]=this._array[t]|i)},isMarked:function(n){var t=Bridge.Int.div(n,System.Collections.Generic.BitHelper.IntSize)|0,i;return t<this._length&&t>=0?(i=System.Collections.Generic.BitHelper.MarkedBitFlag<<n%System.Collections.Generic.BitHelper.IntSize,(this._array[t]&i)!=0):!1}});Bridge.define("Bridge.Collections.EnumerableHelpers",{statics:{toArray:function(n,t){var i={},r={v:Bridge.Collections.EnumerableHelpers.toArray$1(n,t,i)};return System.Array.resize(r,i.v,Bridge.getDefaultValue(n)),r.v},toArray$1:function(n,t,i){var u=Bridge.getEnumerator(t,null,n),s,f,r,e,o;try{if(u.System$Collections$IEnumerator$moveNext()){for(s=4,f={v:System.Array.init(s,function(){return Bridge.getDefaultValue(n)})},f.v[0]=u[Bridge.geti(u,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(n)+"$getCurrent$1","getCurrent$1")](),r=1;u.System$Collections$IEnumerator$moveNext();)r===f.v.length&&(e=2146435071,o=r<<1,o>>>0>e&&(o=e<=r?r+1|0:e),System.Array.resize(f,o,Bridge.getDefaultValue(n))),f.v[Bridge.identity(r,r=r+1|0)]=u[Bridge.geti(u,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(n)+"$getCurrent$1","getCurrent$1")]();return i.v=r,f.v}}finally{Bridge.hasValue(u)&&u.dispose()}return i.v=0,System.Array.init(0,function(){return Bridge.getDefaultValue(n)})}}});Bridge.define("System.Collections.Generic.HashSet$1",function(n){return{inherits:[System.Collections.Generic.ICollection$1(n),System.Collections.Generic.ISet$1(n)],statics:{Lower31BitMask:2147483647,ShrinkThreshold:3,hashSetEquals:function(t,i,r){var u,f,e,s,h,o,c;if(t==null)return i==null;if(i==null)return!1;if(System.Collections.Generic.HashSet$1(n).areEqualityComparersEqual(t,i)){if(t.getCount()!==i.getCount())return!1;for(u=Bridge.getEnumerator(i);u.moveNext();)if(s=u.getCurrent(),!t.contains(s))return!1;return!0}for(f=Bridge.getEnumerator(i);f.moveNext();){for(h=f.getCurrent(),o=!1,e=Bridge.getEnumerator(t);e.moveNext();)if(c=e.getCurrent(),r["System$Collections$Generic$IEqualityComparer$1$"+Bridge.getTypeAlias(n)+"$equals2"](h,c)){o=!0;break}if(!o)return!1}return!0},areEqualityComparersEqual:function(n,t){return Bridge.equals(n.getComparer(),t.getComparer())}},_buckets:null,_slots:null,_count:0,_lastIndex:0,_freeList:0,_comparer:null,_version:0,config:{alias:["System$Collections$Generic$ICollection$1$T$add","System$Collections$Generic$ICollection$1$"+Bridge.getTypeAlias(n)+"$add","clear","System$Collections$Generic$ICollection$1$"+Bridge.getTypeAlias(n)+"$clear","contains","System$Collections$Generic$ICollection$1$"+Bridge.getTypeAlias(n)+"$contains","copyTo","System$Collections$Generic$ICollection$1$"+Bridge.getTypeAlias(n)+"$copyTo","remove","System$Collections$Generic$ICollection$1$"+Bridge.getTypeAlias(n)+"$remove","getCount","System$Collections$Generic$ICollection$1$"+Bridge.getTypeAlias(n)+"$getCount","getIsReadOnly","System$Collections$Generic$ICollection$1$"+Bridge.getTypeAlias(n)+"$getIsReadOnly","System$Collections$Generic$IEnumerable$1$T$getEnumerator","System$Collections$Generic$IEnumerable$1$"+Bridge.getTypeAlias(n)+"$getEnumerator","add","System$Collections$Generic$ISet$1$"+Bridge.getTypeAlias(n)+"$add","unionWith","System$Collections$Generic$ISet$1$"+Bridge.getTypeAlias(n)+"$unionWith","intersectWith","System$Collections$Generic$ISet$1$"+Bridge.getTypeAlias(n)+"$intersectWith","exceptWith","System$Collections$Generic$ISet$1$"+Bridge.getTypeAlias(n)+"$exceptWith","symmetricExceptWith","System$Collections$Generic$ISet$1$"+Bridge.getTypeAlias(n)+"$symmetricExceptWith","isSubsetOf","System$Collections$Generic$ISet$1$"+Bridge.getTypeAlias(n)+"$isSubsetOf","isProperSubsetOf","System$Collections$Generic$ISet$1$"+Bridge.getTypeAlias(n)+"$isProperSubsetOf","isSupersetOf","System$Collections$Generic$ISet$1$"+Bridge.getTypeAlias(n)+"$isSupersetOf","isProperSupersetOf","System$Collections$Generic$ISet$1$"+Bridge.getTypeAlias(n)+"$isProperSupersetOf","overlaps","System$Collections$Generic$ISet$1$"+Bridge.getTypeAlias(n)+"$overlaps","setEquals","System$Collections$Generic$ISet$1$"+Bridge.getTypeAlias(n)+"$setEquals"]},ctor:function(){System.Collections.Generic.HashSet$1(n).$ctor3.call(this,System.Collections.Generic.EqualityComparer$1(n).def)},$ctor3:function(t){this.$initialize();t==null&&(t=System.Collections.Generic.EqualityComparer$1(n).def);this._comparer=t;this._lastIndex=0;this._count=0;this._freeList=-1;this._version=0},$ctor1:function(t){System.Collections.Generic.HashSet$1(n).$ctor2.call(this,t,System.Collections.Generic.EqualityComparer$1(n).def)},$ctor2:function(t,i){if(System.Collections.Generic.HashSet$1(n).$ctor3.call(this,i),t==null)throw new System.ArgumentNullException("collection");var r=0,u=Bridge.as(t,System.Collections.Generic.ICollection$1(n));u!=null&&(r=System.Array.getCount(u,n));this.initialize(r);this.unionWith(t);(this._count===0&&this._slots.length>System.Collections.HashHelpers.getMinPrime()||this._count>0&&(Bridge.Int.div(this._slots.length,this._count)|0)>System.Collections.Generic.HashSet$1(n).ShrinkThreshold)&&this.trimExcess()},getCount:function(){return this._count},getIsReadOnly:function(){return!1},getComparer:function(){return this._comparer},System$Collections$Generic$ICollection$1$T$add:function(n){this.addIfNotPresent(n)},add:function(n){return this.addIfNotPresent(n)},clear:function(){var t,i;if(this._lastIndex>0){for(t=0;t<this._lastIndex;t=t+1|0)this._slots[t]=new(System.Collections.Generic.HashSet$1.Slot(n));for(i=0;i<this._buckets.length;i=i+1|0)this._buckets[i]=0;this._lastIndex=0;this._count=0;this._freeList=-1}this._version=this._version+1|0},arrayClear:function(){},contains:function(t){var r,i;if(this._buckets!=null)for(r=this.internalGetHashCode(t),i=this._buckets[r%this._buckets.length]-1|0;i>=0;i=this._slots[i].next)if(this._slots[i].hashCode===r&&this._comparer["System$Collections$Generic$IEqualityComparer$1$"+Bridge.getTypeAlias(n)+"$equals2"](this._slots[i].value,t))return!0;return!1},copyTo:function(n,t){this.copyTo$2(n,t,this._count)},copyTo$1:function(n){this.copyTo$2(n,0,this._count)},copyTo$2:function(n,t,i){var u,r;if(n==null)throw new System.ArgumentNullException("array");if(t<0)throw new System.ArgumentOutOfRangeException("arrayIndex");if(i<0)throw new System.ArgumentOutOfRangeException("count");if(t>n.length||i>(n.length-t|0))throw new System.ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length.");for(u=0,r=0;r<this._lastIndex&&u<i;r=r+1|0)this._slots[r].hashCode>=0&&(n[t+u|0]=this._slots[r].value,u=u+1|0)},remove:function(t){var i;if(this._buckets!=null){var u=this.internalGetHashCode(t),f=u%this._buckets.length,r=-1;for(i=this._buckets[f]-1|0;i>=0;r=i,i=this._slots[i].next)if(this._slots[i].hashCode===u&&this._comparer["System$Collections$Generic$IEqualityComparer$1$"+Bridge.getTypeAlias(n)+"$equals2"](this._slots[i].value,t))return r<0?this._buckets[f]=this._slots[i].next+1|0:this._slots[r].next=this._slots[i].next,this._slots[i].hashCode=-1,this._slots[i].value=Bridge.getDefaultValue(n),this._slots[i].next=this._freeList,this._count=this._count-1|0,this._version=this._version+1|0,this._count===0?(this._lastIndex=0,this._freeList=-1):this._freeList=i,!0}return!1},getEnumerator:function(){return new(System.Collections.Generic.HashSet$1.Enumerator(n).$ctor1)(this)},System$Collections$Generic$IEnumerable$1$T$getEnumerator:function(){return new(System.Collections.Generic.HashSet$1.Enumerator(n).$ctor1)(this)},System$Collections$IEnumerable$getEnumerator:function(){return new(System.Collections.Generic.HashSet$1.Enumerator(n).$ctor1)(this)},unionWith:function(t){var i,r;if(t==null)throw new System.ArgumentNullException("other");for(i=Bridge.getEnumerator(t,null,n);i.moveNext();)r=i.getCurrent(),this.addIfNotPresent(r)},intersectWith:function(t){var r,i;if(t==null)throw new System.ArgumentNullException("other");if(this._count!==0){if(r=Bridge.as(t,System.Collections.Generic.ICollection$1(n)),r!=null){if(System.Array.getCount(r,n)===0){this.clear();return}if(i=Bridge.as(t,System.Collections.Generic.HashSet$1(n)),i!=null&&System.Collections.Generic.HashSet$1(n).areEqualityComparersEqual(this,i)){this.intersectWithHashSetWithSameEC(i);return}}this.intersectWithEnumerable(t)}},exceptWith:function(t){var i,r;if(t==null)throw new System.ArgumentNullException("other");if(this._count!==0){if(Bridge.referenceEquals(t,this)){this.clear();return}for(i=Bridge.getEnumerator(t,null,n);i.moveNext();)r=i.getCurrent(),this.remove(r)}},symmetricExceptWith:function(t){if(t==null)throw new System.ArgumentNullException("other");if(this._count===0){this.unionWith(t);return}if(Bridge.referenceEquals(t,this)){this.clear();return}var i=Bridge.as(t,System.Collections.Generic.HashSet$1(n));i!=null&&System.Collections.Generic.HashSet$1(n).areEqualityComparersEqual(this,i)?this.symmetricExceptWithUniqueHashSet(i):this.symmetricExceptWithEnumerable(t)},isSubsetOf:function(t){var i,r;if(t==null)throw new System.ArgumentNullException("other");return this._count===0?!0:(i=Bridge.as(t,System.Collections.Generic.HashSet$1(n)),i!=null&&System.Collections.Generic.HashSet$1(n).areEqualityComparersEqual(this,i)?this._count>i.getCount()?!1:this.isSubsetOfHashSetWithSameEC(i):(r=this.checkUniqueAndUnfoundElements(t,!1).$clone(),r.uniqueCount===this._count&&r.unfoundCount>=0))},isProperSubsetOf:function(t){var r,i,u;if(t==null)throw new System.ArgumentNullException("other");if(r=Bridge.as(t,System.Collections.Generic.ICollection$1(n)),r!=null){if(this._count===0)return System.Array.getCount(r,n)>0;if(i=Bridge.as(t,System.Collections.Generic.HashSet$1(n)),i!=null&&System.Collections.Generic.HashSet$1(n).areEqualityComparersEqual(this,i))return this._count>=i.getCount()?!1:this.isSubsetOfHashSetWithSameEC(i)}return u=this.checkUniqueAndUnfoundElements(t,!1).$clone(),u.uniqueCount===this._count&&u.unfoundCount>0},isSupersetOf:function(t){var r,i;if(t==null)throw new System.ArgumentNullException("other");if(r=Bridge.as(t,System.Collections.Generic.ICollection$1(n)),r!=null){if(System.Array.getCount(r,n)===0)return!0;if(i=Bridge.as(t,System.Collections.Generic.HashSet$1(n)),i!=null&&System.Collections.Generic.HashSet$1(n).areEqualityComparersEqual(this,i)&&i.getCount()>this._count)return!1}return this.containsAllElements(t)},isProperSupersetOf:function(t){var r,i,u;if(t==null)throw new System.ArgumentNullException("other");if(this._count===0)return!1;if(r=Bridge.as(t,System.Collections.Generic.ICollection$1(n)),r!=null){if(System.Array.getCount(r,n)===0)return!0;if(i=Bridge.as(t,System.Collections.Generic.HashSet$1(n)),i!=null&&System.Collections.Generic.HashSet$1(n).areEqualityComparersEqual(this,i))return i.getCount()>=this._count?!1:this.containsAllElements(i)}return u=this.checkUniqueAndUnfoundElements(t,!0).$clone(),u.uniqueCount<this._count&&u.unfoundCount===0},overlaps:function(t){var i,r;if(t==null)throw new System.ArgumentNullException("other");if(this._count===0)return!1;for(i=Bridge.getEnumerator(t,null,n);i.moveNext();)if(r=i.getCurrent(),this.contains(r))return!0;return!1},setEquals:function(t){var i,r,u;if(t==null)throw new System.ArgumentNullException("other");return i=Bridge.as(t,System.Collections.Generic.HashSet$1(n)),i!=null&&System.Collections.Generic.HashSet$1(n).areEqualityComparersEqual(this,i)?this._count!==i.getCount()?!1:this.containsAllElements(i):(r=Bridge.as(t,System.Collections.Generic.ICollection$1(n)),r!=null&&this._count===0&&System.Array.getCount(r,n)>0)?!1:(u=this.checkUniqueAndUnfoundElements(t,!0).$clone(),u.uniqueCount===this._count&&u.unfoundCount===0)},removeWhere:function(n){var i,t,r;if(Bridge.staticEquals(n,null))throw new System.ArgumentNullException("match");for(i=0,t=0;t<this._lastIndex;t=t+1|0)this._slots[t].hashCode>=0&&(r=this._slots[t].value,n(r)&&this.remove(r)&&(i=i+1|0));return i},trimExcess:function(){var i,e;if(this._count===0)this._buckets=null,this._slots=null,this._version=this._version+1|0;else{var u=System.Collections.HashHelpers.getPrime(this._count),r=System.Array.init(u,function(){return new(System.Collections.Generic.HashSet$1.Slot(n))}),f=System.Array.init(u,0),t=0;for(i=0;i<this._lastIndex;i=i+1|0)this._slots[i].hashCode>=0&&(r[t]=this._slots[i].$clone(),e=r[t].hashCode%u,r[t].next=f[e]-1|0,f[e]=t+1|0,t=t+1|0);this._lastIndex=t;this._slots=r;this._buckets=f;this._freeList=-1}},initialize:function(t){var i=System.Collections.HashHelpers.getPrime(t);this._buckets=System.Array.init(i,0);this._slots=System.Array.init(i,function(){return new(System.Collections.Generic.HashSet$1.Slot(n))})},increaseCapacity:function(){var n=System.Collections.HashHelpers.expandPrime(this._count);if(n<=this._count)throw new System.ArgumentException("HashSet capacity is too big.");this.setCapacity(n,!1)},setCapacity:function(t,i){var r=System.Array.init(t,function(){return new(System.Collections.Generic.HashSet$1.Slot(n))}),e,u,o,f,s;if(this._slots!=null)for(e=0;e<this._lastIndex;e=e+1|0)r[e]=this._slots[e].$clone();if(i)for(u=0;u<this._lastIndex;u=u+1|0)r[u].hashCode!==-1&&(r[u].hashCode=this.internalGetHashCode(r[u].value));for(o=System.Array.init(t,0),f=0;f<this._lastIndex;f=f+1|0)s=r[f].hashCode%t,r[f].next=o[s]-1|0,o[s]=f+1|0;this._slots=r;this._buckets=o},addIfNotPresent:function(t){var u,f,r,i;for(this._buckets==null&&this.initialize(0),u=this.internalGetHashCode(t),f=u%this._buckets.length,r=this._buckets[f]-1|0;r>=0;r=this._slots[r].next)if(this._slots[r].hashCode===u&&this._comparer["System$Collections$Generic$IEqualityComparer$1$"+Bridge.getTypeAlias(n)+"$equals2"](this._slots[r].value,t))return!1;return this._freeList>=0?(i=this._freeList,this._freeList=this._slots[i].next):(this._lastIndex===this._slots.length&&(this.increaseCapacity(),f=u%this._buckets.length),i=this._lastIndex,this._lastIndex=this._lastIndex+1|0),this._slots[i].hashCode=u,this._slots[i].value=t,this._slots[i].next=this._buckets[f]-1|0,this._buckets[f]=i+1|0,this._count=this._count+1|0,this._version=this._version+1|0,!0},containsAllElements:function(t){for(var r,i=Bridge.getEnumerator(t,null,n);i.moveNext();)if(r=i.getCurrent(),!this.contains(r))return!1;return!0},isSubsetOfHashSetWithSameEC:function(n){for(var i,t=Bridge.getEnumerator(this);t.moveNext();)if(i=t.getCurrent(),!n.contains(i))return!1;return!0},intersectWithHashSetWithSameEC:function(n){for(var i,t=0;t<this._lastIndex;t=t+1|0)this._slots[t].hashCode>=0&&(i=this._slots[t].value,n.contains(i)||this.remove(i))},intersectWithEnumerable:function(t){for(var e=this._lastIndex,o=System.Collections.Generic.BitHelper.toIntArrayLength(e),h=System.Array.init(o,0),s,f,i,u=new System.Collections.Generic.BitHelper(h,o),r=Bridge.getEnumerator(t,null,n);r.moveNext();)s=r.getCurrent(),f=this.internalIndexOf(s),f>=0&&u.markBit(f);for(i=0;i<e;i=i+1|0)this._slots[i].hashCode>=0&&!u.isMarked(i)&&this.remove(this._slots[i].value)},internalIndexOf:function(t){for(var r=this.internalGetHashCode(t),i=this._buckets[r%this._buckets.length]-1|0;i>=0;i=this._slots[i].next)if(this._slots[i].hashCode===r&&this._comparer["System$Collections$Generic$IEqualityComparer$1$"+Bridge.getTypeAlias(n)+"$equals2"](this._slots[i].value,t))return i;return-1},symmetricExceptWithUniqueHashSet:function(n){for(var i,t=Bridge.getEnumerator(n);t.moveNext();)i=t.getCurrent(),this.remove(i)||this.addIfNotPresent(i)},symmetricExceptWithEnumerable:function(t){var f,e=this._lastIndex,u=System.Collections.Generic.BitHelper.toIntArrayLength(e),o,s,c=System.Array.init(u,0),h,i;for(o=new System.Collections.Generic.BitHelper(c,u),h=System.Array.init(u,0),s=new System.Collections.Generic.BitHelper(h,u),f=Bridge.getEnumerator(t,null,n);f.moveNext();){var l=f.getCurrent(),r={v:0},a=this.addOrGetLocation(l,r);a?s.markBit(r.v):r.v<e&&!s.isMarked(r.v)&&o.markBit(r.v)}for(i=0;i<e;i=i+1|0)o.isMarked(i)&&this.remove(this._slots[i].value)},addOrGetLocation:function(t,i){for(var r,f=this.internalGetHashCode(t),e=f%this._buckets.length,u=this._buckets[e]-1|0;u>=0;u=this._slots[u].next)if(this._slots[u].hashCode===f&&this._comparer["System$Collections$Generic$IEqualityComparer$1$"+Bridge.getTypeAlias(n)+"$equals2"](this._slots[u].value,t))return i.v=u,!1;return this._freeList>=0?(r=this._freeList,this._freeList=this._slots[r].next):(this._lastIndex===this._slots.length&&(this.increaseCapacity(),e=f%this._buckets.length),r=this._lastIndex,this._lastIndex=this._lastIndex+1|0),this._slots[r].hashCode=f,this._slots[r].value=t,this._slots[r].next=this._buckets[e]-1|0,this._buckets[e]=r+1|0,this._count=this._count+1|0,this._version=this._version+1|0,i.v=r,!0},checkUniqueAndUnfoundElements:function(t,i){var s,h,r=new(System.Collections.Generic.HashSet$1.ElementCount(n)),u,v,f,e,a,o;if(this._count===0){for(u=0,s=Bridge.getEnumerator(t,null,n);s.moveNext();){v=s.getCurrent();u=u+1|0;break}return r.uniqueCount=0,r.unfoundCount=u,r.$clone()}var y=this._lastIndex,l=System.Collections.Generic.BitHelper.toIntArrayLength(y),c,p=System.Array.init(l,0);for(c=new System.Collections.Generic.BitHelper(p,l),f=0,e=0,h=Bridge.getEnumerator(t,null,n);h.moveNext();)if(a=h.getCurrent(),o=this.internalIndexOf(a),o>=0)c.isMarked(o)||(c.markBit(o),e=e+1|0);else if(f=f+1|0,i)break;return r.uniqueCount=e,r.unfoundCount=f,r.$clone()},toArray:function(){var t=System.Array.init(this.getCount(),function(){return Bridge.getDefaultValue(n)});return this.copyTo$1(t),t},internalGetHashCode:function(t){return t==null?0:this._comparer["System$Collections$Generic$IEqualityComparer$1$"+Bridge.getTypeAlias(n)+"$getHashCode2"](t)&System.Collections.Generic.HashSet$1(n).Lower31BitMask}}});Bridge.define("System.Collections.Generic.HashSet$1.ElementCount",function(n){return{$kind:"struct",statics:{getDefaultValue:function(){return new(System.Collections.Generic.HashSet$1.ElementCount(n))}},uniqueCount:0,unfoundCount:0,ctor:function(){this.$initialize()},getHashCode:function(){return Bridge.addHash([4920463385,this.uniqueCount,this.unfoundCount])},equals:function(t){return Bridge.is(t,System.Collections.Generic.HashSet$1.ElementCount(n))?Bridge.equals(this.uniqueCount,t.uniqueCount)&&Bridge.equals(this.unfoundCount,t.unfoundCount):!1},$clone:function(t){var i=t||new(System.Collections.Generic.HashSet$1.ElementCount(n));return i.uniqueCount=this.uniqueCount,i.unfoundCount=this.unfoundCount,i}}});Bridge.define("System.Collections.Generic.HashSet$1.Enumerator",function(n){return{inherits:[System.Collections.Generic.IEnumerator$1(n)],$kind:"struct",statics:{getDefaultValue:function(){return new(System.Collections.Generic.HashSet$1.Enumerator(n))}},_set:null,_index:0,_version:0,_current:Bridge.getDefaultValue(n),config:{alias:["dispose","System$IDisposable$dispose","moveNext","System$Collections$IEnumerator$moveNext","getCurrent","System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(n)+"$getCurrent$1"]},$ctor1:function(t){this.$initialize();this._set=t;this._index=0;this._version=t._version;this._current=Bridge.getDefaultValue(n)},ctor:function(){this.$initialize()},getCurrent:function(){return this._current},System$Collections$IEnumerator$getCurrent:function(){if(this._index===0||this._index===(this._set._lastIndex+1|0))throw new System.InvalidOperationException("Enumeration has either not started or has already finished.");return this.getCurrent()},dispose:function(){},moveNext:function(){if(this._version!==this._set._version)throw new System.InvalidOperationException("Collection was modified; enumeration operation may not execute.");while(this._index<this._set._lastIndex){if(this._set._slots[this._index].hashCode>=0)return this._current=this._set._slots[this._index].value,this._index=this._index+1|0,!0;this._index=this._index+1|0}return this._index=this._set._lastIndex+1|0,this._current=Bridge.getDefaultValue(n),!1},System$Collections$IEnumerator$reset:function(){if(this._version!==this._set._version)throw new System.InvalidOperationException("Collection was modified; enumeration operation may not execute.");this._index=0;this._current=Bridge.getDefaultValue(n)},getHashCode:function(){return Bridge.addHash([3788985113,this._set,this._index,this._version,this._current])},equals:function(t){return Bridge.is(t,System.Collections.Generic.HashSet$1.Enumerator(n))?Bridge.equals(this._set,t._set)&&Bridge.equals(this._index,t._index)&&Bridge.equals(this._version,t._version)&&Bridge.equals(this._current,t._current):!1},$clone:function(t){var i=t||new(System.Collections.Generic.HashSet$1.Enumerator(n));return i._set=this._set,i._index=this._index,i._version=this._version,i._current=this._current,i}}});Bridge.define("System.Collections.Generic.HashSet$1.Slot",function(n){return{$kind:"struct",statics:{getDefaultValue:function(){return new(System.Collections.Generic.HashSet$1.Slot(n))}},hashCode:0,value:Bridge.getDefaultValue(n),next:0,ctor:function(){this.$initialize()},getHashCode:function(){return Bridge.addHash([1953459283,this.hashCode,this.value,this.next])},equals:function(t){return Bridge.is(t,System.Collections.Generic.HashSet$1.Slot(n))?Bridge.equals(this.hashCode,t.hashCode)&&Bridge.equals(this.value,t.value)&&Bridge.equals(this.next,t.next):!1},$clone:function(t){var i=t||new(System.Collections.Generic.HashSet$1.Slot(n));return i.hashCode=this.hashCode,i.value=this.value,i.next=this.next,i}}});Bridge.define("System.Collections.Generic.Queue$1",function(n){return{inherits:[System.Collections.Generic.IEnumerable$1(n),System.Collections.ICollection],statics:{MinimumGrow:4,GrowFactor:200,DefaultCapacity:4},_array:null,_head:0,_tail:0,_size:0,_version:0,config:{alias:["getCount","System$Collections$ICollection$getCount","getIsReadOnly","System$Collections$ICollection$getIsReadOnly","System$Collections$Generic$IEnumerable$1$T$getEnumerator","System$Collections$Generic$IEnumerable$1$"+Bridge.getTypeAlias(n)+"$getEnumerator"]},ctor:function(){this.$initialize();this._array=System.Array.init(0,function(){return Bridge.getDefaultValue(n)})},$ctor2:function(t){if(this.$initialize(),t<0)throw new System.ArgumentOutOfRangeException("capacity","Non-negative number required.");this._array=System.Array.init(t,function(){return Bridge.getDefaultValue(n)})},$ctor1:function(t){if(this.$initialize(),t==null)throw new System.ArgumentNullException("collection");this._array=System.Array.init(System.Collections.Generic.Queue$1(n).DefaultCapacity,function(){return Bridge.getDefaultValue(n)});var i=Bridge.getEnumerator(t,null,n);try{while(i.System$Collections$IEnumerator$moveNext())this.enqueue(i[Bridge.geti(i,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(n)+"$getCurrent$1","getCurrent$1")]())}finally{Bridge.hasValue(i)&&i.dispose()}},getCount:function(){return this._size},getIsReadOnly:function(){return!1},clear:function(){this._head<this._tail?System.Array.fill(this._array,Bridge.getDefaultValue(n),this._head,this._size):(System.Array.fill(this._array,Bridge.getDefaultValue(n),this._head,this._array.length-this._head|0),System.Array.fill(this._array,Bridge.getDefaultValue(n),0,this._tail));this._head=0;this._tail=0;this._size=0;this._version=this._version+1|0},copyTo:function(n,t){var r,i,u;if(n==null)throw new System.ArgumentNullException("array");if(t<0||t>n.length)throw new System.ArgumentOutOfRangeException("arrayIndex","Index was out of range. Must be non-negative and less than the size of the collection.");if(r=n.length,(r-t|0)<this._size)throw new System.ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");(i=(r-t|0)<this._size?r-t|0:this._size,i!==0)&&(u=(this._array.length-this._head|0)<i?this._array.length-this._head|0:i,System.Array.copy(this._array,this._head,n,t,u),i=i-u|0,i>0&&System.Array.copy(this._array,0,n,(t+this._array.length|0)-this._head|0,i))},enqueue:function(t){if(this._size===this._array.length){var i=Bridge.Int.div(this._array.length*System.Collections.Generic.Queue$1(n).GrowFactor|0,100)|0;i<(this._array.length+System.Collections.Generic.Queue$1(n).MinimumGrow|0)&&(i=this._array.length+System.Collections.Generic.Queue$1(n).MinimumGrow|0);this.setCapacity(i)}this._array[this._tail]=t;this._tail=this.moveNext(this._tail);this._size=this._size+1|0;this._version=this._version+1|0},getEnumerator:function(){return new(System.Collections.Generic.Queue$1.Enumerator(n).$ctor1)(this)},System$Collections$Generic$IEnumerable$1$T$getEnumerator:function(){return new(System.Collections.Generic.Queue$1.Enumerator(n).$ctor1)(this)},System$Collections$IEnumerable$getEnumerator:function(){return new(System.Collections.Generic.Queue$1.Enumerator(n).$ctor1)(this)},dequeue:function(){if(this._size===0)throw new System.InvalidOperationException("Queue empty.");var t=this._array[this._head];return this._array[this._head]=Bridge.getDefaultValue(n),this._head=this.moveNext(this._head),this._size=this._size-1|0,this._version=this._version+1|0,t},peek:function(){if(this._size===0)throw new System.InvalidOperationException("Queue empty.");return this._array[this._head]},contains:function(t){for(var i=this._head,r=this._size,u=System.Collections.Generic.EqualityComparer$1(n).def;Bridge.identity(r,r=r-1|0)>0;){if(t==null){if(this._array[i]==null)return!0}else if(this._array[i]!=null&&u.equals2(this._array[i],t))return!0;i=this.moveNext(i)}return!1},getElement:function(n){return this._array[(this._head+n|0)%this._array.length]},toArray:function(){var t=System.Array.init(this._size,function(){return Bridge.getDefaultValue(n)});return this._size===0?t:(this._head<this._tail?System.Array.copy(this._array,this._head,t,0,this._size):(System.Array.copy(this._array,this._head,t,0,this._array.length-this._head|0),System.Array.copy(this._array,0,t,this._array.length-this._head|0,this._tail)),t)},setCapacity:function(t){var i=System.Array.init(t,function(){return Bridge.getDefaultValue(n)});this._size>0&&(this._head<this._tail?System.Array.copy(this._array,this._head,i,0,this._size):(System.Array.copy(this._array,this._head,i,0,this._array.length-this._head|0),System.Array.copy(this._array,0,i,this._array.length-this._head|0,this._tail)));this._array=i;this._head=0;this._tail=this._size===t?0:this._size;this._version=this._version+1|0},moveNext:function(n){var t=n+1|0;return t===this._array.length?0:t},trimExcess:function(){var n=Bridge.Int.clip32(this._array.length*.9);this._size<n&&this.setCapacity(this._size)}}});Bridge.define("System.Collections.Generic.Queue$1.Enumerator",function(n){return{inherits:[System.Collections.Generic.IEnumerator$1(n),System.Collections.IEnumerator],$kind:"struct",statics:{getDefaultValue:function(){return new(System.Collections.Generic.Queue$1.Enumerator(n))}},_q:null,_index:0,_version:0,_currentElement:Bridge.getDefaultValue(n),config:{alias:["dispose","System$IDisposable$dispose","moveNext","System$Collections$IEnumerator$moveNext","getCurrent","System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(n)+"$getCurrent$1"]},$ctor1:function(t){this.$initialize();this._q=t;this._version=this._q._version;this._index=-1;this._currentElement=Bridge.getDefaultValue(n)},ctor:function(){this.$initialize()},getCurrent:function(){if(this._index<0)if(this._index===-1)throw new System.InvalidOperationException("Enumeration has not started. Call MoveNext.");else throw new System.InvalidOperationException("Enumeration already finished.");return this._currentElement},System$Collections$IEnumerator$getCurrent:function(){return this.getCurrent()},dispose:function(){this._index=-2;this._currentElement=Bridge.getDefaultValue(n)},moveNext:function(){if(this._version!==this._q._version)throw new System.InvalidOperationException("Collection was modified; enumeration operation may not execute.");return this._index===-2?!1:(this._index=this._index+1|0,this._index===this._q._size)?(this._index=-2,this._currentElement=Bridge.getDefaultValue(n),!1):(this._currentElement=this._q.getElement(this._index),!0)},System$Collections$IEnumerator$reset:function(){if(this._version!==this._q._version)throw new System.InvalidOperationException("Collection was modified; enumeration operation may not execute.");this._index=-1;this._currentElement=Bridge.getDefaultValue(n)},getHashCode:function(){return Bridge.addHash([3788985113,this._q,this._index,this._version,this._currentElement])},equals:function(t){return Bridge.is(t,System.Collections.Generic.Queue$1.Enumerator(n))?Bridge.equals(this._q,t._q)&&Bridge.equals(this._index,t._index)&&Bridge.equals(this._version,t._version)&&Bridge.equals(this._currentElement,t._currentElement):!1},$clone:function(t){var i=t||new(System.Collections.Generic.Queue$1.Enumerator(n));return i._q=this._q,i._index=this._index,i._version=this._version,i._currentElement=this._currentElement,i}}});Bridge.define("System.Collections.Generic.Stack$1",function(n){return{inherits:[System.Collections.Generic.IEnumerable$1(n),System.Collections.ICollection],statics:{DefaultCapacity:4},_array:null,_size:0,_version:0,config:{alias:["getCount","System$Collections$ICollection$getCount","getIsReadOnly","System$Collections$ICollection$getIsReadOnly","System$Collections$Generic$IEnumerable$1$T$getEnumerator","System$Collections$Generic$IEnumerable$1$"+Bridge.getTypeAlias(n)+"$getEnumerator"]},ctor:function(){this.$initialize();this._array=System.Array.init(0,function(){return Bridge.getDefaultValue(n)})},$ctor2:function(t){if(this.$initialize(),t<0)throw new System.ArgumentOutOfRangeException("capacity","Non-negative number required.");this._array=System.Array.init(t,function(){return Bridge.getDefaultValue(n)})},$ctor1:function(t){if(this.$initialize(),t==null)throw new System.ArgumentNullException("collection");var i={};this._array=Bridge.Collections.EnumerableHelpers.toArray$1(n,t,i);this._size=i.v},getCount:function(){return this._size},getIsReadOnly:function(){return!1},clear:function(){System.Array.fill(this._array,Bridge.getDefaultValue(n),0,this._size);this._size=0;this._version=this._version+1|0},contains:function(t){for(var i=this._size,r=System.Collections.Generic.EqualityComparer$1(n).def;Bridge.identity(i,i=i-1|0)>0;)if(t==null){if(this._array[i]==null)return!0}else if(this._array[i]!=null&&r.equals2(this._array[i],t))return!0;return!1},copyTo:function(n,t){var i,u,r;if(n==null)throw new System.ArgumentNullException("array");if(t<0||t>n.length)throw new System.ArgumentOutOfRangeException("arrayIndex","Non-negative number required.");if((n.length-t|0)<this._size)throw new System.ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");if(Bridge.referenceEquals(n,this._array))System.Array.copy(this._array,0,n,t,this._size),System.Array.reverse(n,t,this._size);else for(i=0,u=t+this._size|0,r=0;r<this._size;r=r+1|0)n[u=u-1|0]=this._array[Bridge.identity(i,i=i+1|0)]},copyTo$1:function(n,t){if(n==null)throw new System.ArgumentNullException("array");if(System.Array.getRank(n)!==1)throw new System.ArgumentException("Only single dimensional arrays are supported for the requested action.");if(System.Array.getLower(n,0)!==0)throw new System.ArgumentException("The lower bound of target array must be zero.");if(t<0||t>n.length)throw new System.ArgumentOutOfRangeException("arrayIndex","Non-negative number required.");if((n.length-t|0)<this._size)throw new System.ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");try{System.Array.copy(this._array,0,n,t,this._size);System.Array.reverse(n,t,this._size)}catch(i){i=System.Exception.create(i);throw new System.ArgumentException("Target array type is not compatible with the type of items in the collection.");}},getEnumerator:function(){return new(System.Collections.Generic.Stack$1.Enumerator(n).$ctor1)(this)},System$Collections$Generic$IEnumerable$1$T$getEnumerator:function(){return new(System.Collections.Generic.Stack$1.Enumerator(n).$ctor1)(this)},System$Collections$IEnumerable$getEnumerator:function(){return new(System.Collections.Generic.Stack$1.Enumerator(n).$ctor1)(this)},trimExcess:function(){var i=Bridge.Int.clip32(this._array.length*.9),t;this._size<i&&(t={v:this._array},System.Array.resize(t,this._size,Bridge.getDefaultValue(n)),this._array=t.v,this._version=this._version+1|0)},peek:function(){if(this._size===0)throw new System.InvalidOperationException("Stack empty.");return this._array[this._size-1|0]},pop:function(){if(this._size===0)throw new System.InvalidOperationException("Stack empty.");this._version=this._version+1|0;var t=this._array[this._size=this._size-1|0];return this._array[this._size]=Bridge.getDefaultValue(n),t},push:function(t){if(this._size===this._array.length){var i={v:this._array};System.Array.resize(i,this._array.length===0?System.Collections.Generic.Stack$1(n).DefaultCapacity:2*this._array.length|0,Bridge.getDefaultValue(n));this._array=i.v}this._array[Bridge.identity(this._size,this._size=this._size+1|0)]=t;this._version=this._version+1|0},toArray:function(){for(var i=System.Array.init(this._size,function(){return Bridge.getDefaultValue(n)}),t=0;t<this._size;)i[t]=this._array[(this._size-t|0)-1|0],t=t+1|0;return i}}});Bridge.define("System.Collections.Generic.Stack$1.Enumerator",function(n){return{inherits:[System.Collections.Generic.IEnumerator$1(n),System.Collections.IEnumerator],$kind:"struct",statics:{getDefaultValue:function(){return new(System.Collections.Generic.Stack$1.Enumerator(n))}},_stack:null,_index:0,_version:0,_currentElement:Bridge.getDefaultValue(n),config:{alias:["dispose","System$IDisposable$dispose","moveNext","System$Collections$IEnumerator$moveNext","getCurrent","System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(n)+"$getCurrent$1"]},$ctor1:function(t){this.$initialize();this._stack=t;this._version=this._stack._version;this._index=-2;this._currentElement=Bridge.getDefaultValue(n)},ctor:function(){this.$initialize()},getCurrent:function(){if(this._index===-2)throw new System.InvalidOperationException("Enumeration has not started. Call MoveNext.");if(this._index===-1)throw new System.InvalidOperationException("Enumeration already finished.");return this._currentElement},System$Collections$IEnumerator$getCurrent:function(){if(this._index===-2)throw new System.InvalidOperationException("Enumeration has not started. Call MoveNext.");if(this._index===-1)throw new System.InvalidOperationException("Enumeration already finished.");return this._currentElement},dispose:function(){this._index=-1},moveNext:function(){var t;if(this._version!==this._stack._version)throw new System.InvalidOperationException("Collection was modified; enumeration operation may not execute.");return this._index===-2?(this._index=this._stack._size-1|0,t=this._index>=0,t&&(this._currentElement=this._stack._array[this._index]),t):this._index===-1?!1:(t=(this._index=this._index-1|0)>=0,this._currentElement=t?this._stack._array[this._index]:Bridge.getDefaultValue(n),t)},System$Collections$IEnumerator$reset:function(){if(this._version!==this._stack._version)throw new System.InvalidOperationException("Collection was modified; enumeration operation may not execute.");this._index=-2;this._currentElement=Bridge.getDefaultValue(n)},getHashCode:function(){return Bridge.addHash([3788985113,this._stack,this._index,this._version,this._currentElement])},equals:function(t){return Bridge.is(t,System.Collections.Generic.Stack$1.Enumerator(n))?Bridge.equals(this._stack,t._stack)&&Bridge.equals(this._index,t._index)&&Bridge.equals(this._version,t._version)&&Bridge.equals(this._currentElement,t._currentElement):!1},$clone:function(t){var i=t||new(System.Collections.Generic.Stack$1.Enumerator(n));return i._stack=this._stack,i._index=this._index,i._version=this._version,i._currentElement=this._currentElement,i}}});Bridge.define("System.Collections.HashHelpers",{statics:{HashPrime:101,primes:null,MaxPrimeArrayLength:2146435069,config:{init:function(){this.primes=[3,7,11,17,23,29,37,47,59,71,89,107,131,163,197,239,293,353,431,521,631,761,919,1103,1327,1597,1931,2333,2801,3371,4049,4861,5839,7013,8419,10103,12143,14591,17519,21023,25229,30293,36353,43627,52361,62851,75431,90523,108631,130363,156437,187751,225307,270371,324449,389357,467237,560689,672827,807403,968897,1162687,1395263,1674319,2009191,2411033,2893249,3471899,4166287,4999559,5999471,7199369]}},isPrime:function(n){var i,t;if((n&1)!=0){for(i=Bridge.Int.clip32(Math.sqrt(n)),t=3;t<=i;t=t+2|0)if(n%t==0)return!1;return!0}return n===2},getPrime:function(n){var i,r,t;if(n<0)throw new System.ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table.");for(i=0;i<System.Collections.HashHelpers.primes.length;i=i+1|0)if(r=System.Collections.HashHelpers.primes[i],r>=n)return r;for(t=n|1;t<2147483647;t=t+2|0)if(System.Collections.HashHelpers.isPrime(t)&&(t-1|0)%System.Collections.HashHelpers.HashPrime!=0)return t;return n},getMinPrime:function(){return System.Collections.HashHelpers.primes[0]},expandPrime:function(n){var t=2*n|0;return t>>>0>System.Collections.HashHelpers.MaxPrimeArrayLength&&System.Collections.HashHelpers.MaxPrimeArrayLength>n?System.Collections.HashHelpers.MaxPrimeArrayLength:System.Collections.HashHelpers.getPrime(t)}}})});