package ${package.ServiceImpl};

import ${package.Entity}.${entity};
import ${package.Mapper}.${table.mapperName};
import ${package.Service}.${table.serviceName};
import ${superServiceImplClassPackage};

import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zyplayer.doc.core.exception.ConfirmException;
import com.zyplayer.doc.data.service.params.PageRequest;
import com.zyplayer.doc.data.config.security.DocUserUtil;
import com.zyplayer.doc.data.config.security.DocUserDetails;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * <p>
 * ${table.comment!} 服务实现类
 * </p>
 *
 * @author ${author}
 * @since ${date}
 */
@Service
<#if kotlin>
open class ${table.serviceImplName} : ${superServiceImplClass}<${table.mapperName}, ${entity}>(), ${table.serviceName} {

}
<#else>
public class ${table.serviceImplName} extends ${superServiceImplClass}<${table.mapperName}, ${entity}> implements ${table.serviceName} {

	/**
	* 分页查询列表
	*/
	@Override
	public IPage<${entity}> listPage(${entity} ${entity?uncap_first}, PageRequest<${entity}> pageRequest) {
		LambdaQueryWrapper<${entity}> queryWrapper = new QueryWrapper<${entity}>().lambda();
		queryWrapper.eq(${entity}::getYn, 1);
		queryWrapper.orderByDesc(${entity}::getId);
		Page<${entity}> page = pageRequest.toPage();
		return this.page(page, queryWrapper);
	}

	/**
	* 保存
	*/
	@Override
	@Transactional(rollbackFor = Exception.class)
	public ${entity} saveRecord(${entity} ${entity?uncap_first}) {
		DocUserDetails currentUser = DocUserUtil.getCurrentUser();
		${entity?uncap_first}.setModified(new Date());
		${entity?uncap_first}.setModifyUser(currentUser.getUsername());
		${entity?uncap_first}.setModifyUserId(currentUser.getUserId());
		if (${entity?uncap_first}.getId() == null) {
			${entity?uncap_first}.setYn(1);
			${entity?uncap_first}.setCreated(new Date());
			${entity?uncap_first}.setCreateUser(currentUser.getUsername());
			${entity?uncap_first}.setCreateUserId(currentUser.getUserId());
			this.save(${entity?uncap_first});
		} else {
			this.updateById(${entity?uncap_first});
		}
		return ${entity?uncap_first};
	}

	/**
	* 删除
	*/
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void deleteRecord(Long id) {
		${entity} ${entity?uncap_first} = getById(id);
		if (${entity?uncap_first} == null) {
 			throw new ConfirmException(ErrorEnum.RECORD_NOT_FOUND);
		}
		this.removeById(id);
	}
 }
</#if>
