<template>
    <div class="template-data-list">
        <a-card>
	        <a-form :label-col="{span: 6}" :wrapper-col="{span: 18}">
		        <a-row>
<#list cfg.columnConfig as tables>
    <#if tables.className == entity>
        <#list tables.columns as column>
            <#if column.filter>
                <#-- ----------  下拉框  ---------->
                <#if column.componentType == 'select'>
                    <a-col :span="6">
                        <a-form-item label="${column.name}">
                            <a-select placeholder="${column.placeholder}" v-model:value="searchParam.${column.column}" showSearch option-filter-prop="name">
                                <a-select-option value="">全部</a-select-option>
                    <#list column.enums as enumItem>
                        <#if column.dataType=='number'>
                                <a-select-option :value="${enumItem.value}">${enumItem.label}</a-select-option>
                        <#else>
                                <a-select-option value="${enumItem.value}">${enumItem.label}</a-select-option>
                        </#if>
                    </#list>
                            </a-select>
                        </a-form-item>
                    </a-col>
                <#-- ----------  输入框  ---------->
                <#else>
                    <a-col :span="6">
                        <a-form-item label="${column.name}">
                            <a-input placeholder="${column.placeholder}" v-model:value="searchParam.${column.column}"/>
                        </a-form-item>
                    </a-col>
                </#if>
            </#if>
        </#list>
    </#if>
</#list>
		            <a-col :span="6" style="text-align: right;">
			            <a-button type="primary" @click="searchDataList">查询</a-button>
			            <a-button :style="{ marginLeft: '8px' }" @click="showCreateModal">新建</a-button>
		            </a-col>
	            </a-row>
            </a-form>
            <a-table
                    :columns="dataListColumns"
                    :rowKey="record => record.id"
                    :dataSource="dataList"
                    :pagination="dataListPagination"
                    :loading="dataListLoading"
                    @change="handleTablePageChange"
                    :scroll="{ x: 1200, y: 'calc(100vh - 340px)' }">
                <template #bodyCell="{ column, record }">
<#list cfg.columnConfig as tables>
    <#if tables.className == entity>
        <#list tables.columns as column>
            <#if column.filter>
                <#-- ----------  下拉框  ---------->
                <#if column.componentType == 'select'>
                    <template v-if="column.dataIndex=== '${column.column}'">
                    <#list column.enums as enumItem>
                        <#if enumItem_index==0>
                        <span v-if="record.${column.column} == ${enumItem.value}">${enumItem.label}</span>
                        <#else>
                        <span v-else-if="record.${column.column} == ${enumItem.value}">${enumItem.label}</span>
                        </#if>
                    </#list>
                        <span v-else>--</span>
                    </template>
                </#if>
                <#-- ----------  输入框  ---------->
                <#if column.componentType == 'input'>
                    <template v-if="column.dataIndex=== '${column.column}'">{{record.${column.column}}}</template>
                </#if>
            </#if>
        </#list>
    </#if>
</#list>
                    <template v-else-if="column.dataIndex=== 'action'">
	                    <a-button type="link" size="small" @click="editDataItem(record)">编辑</a-button>
	                    <a-button type="link" size="small" danger @click="deleteDataItem(record)">删除</a-button>
                    </template>
                </template>
            </a-table>
        </a-card>
        <a-modal :title="dataItemEdit.id>0?'编辑':'新建'" v-model:open="dataItemEditVisible" @ok="dataItemEditOk" okText="确认" cancelText="取消" :maskClosable="false">
            <a-form layout="horizontal" ref="dataItemEditForm" :rules="dataItemEditRules" :model="dataItemEdit" :label-col="{span: 6}" :wrapper-col="{span: 18}">
<#list cfg.columnConfig as tables>
    <#if tables.className == entity>
        <#list tables.columns as column>
            <#-- ----------  下拉框  ---------->
            <#if column.componentType == 'select'>
                <a-form-item label="${column.name}" required name="${column.column}">
                    <a-select placeholder="${column.placeholder}" v-model:value="dataItemEdit.${column.column}" showSearch option-filter-prop="name">
                <#list column.enums as enumItem>
                    <#if column.dataType=='number'>
                        <a-select-option :value="${enumItem.value}">${enumItem.label}</a-select-option>
                    <#else>
                        <a-select-option value="${enumItem.value}">${enumItem.label}</a-select-option>
                    </#if>
                </#list>
                    </a-select>
                </a-form-item>
            </#if>
            <#-- ----------  单行输入  ---------->
            <#if column.componentType == 'input'>
                <a-form-item label="${column.name}" required name="${column.column}">
                    <a-input placeholder="${column.placeholder}" v-model:value="dataItemEdit.${column.column}"></a-input>
                </a-form-item>
            </#if>
            <#-- ----------  多行输入  ---------->
            <#if column.componentType == 'textarea'>
                <a-form-item label="${column.name}" required name="${column.column}">
                    <a-textarea placeholder="${column.placeholder}" v-model:value="dataItemEdit.${column.column}"></a-textarea>
                </a-form-item>
            </#if>
        </#list>
    </#if>
</#list>
            </a-form>
        </a-modal>
    </div>
</template>

<script>
import {toRefs, ref, reactive, onMounted, watch, createVNode} from 'vue';
import {useRouter, useRoute} from "vue-router";
import {useStore} from 'vuex';
import {message, Modal} from 'ant-design-vue';
import {ExclamationCircleOutlined} from '@ant-design/icons-vue';

import {databoardApi} from '../../api/index';

export default {
	components: {},
	setup() {
		const route = useRoute();
		const store = useStore();
		// 初始化方法
		onMounted(() => {
			searchDataList();
		});
		// 查询参数
		let searchParam = ref({
			pageNum: 1,
			pageSize: 20,
			code: '',
			name: '',
		});
		// 查询参数下拉
		let metaGroupList = ref([]);
		// 列表数据
		let dataList = ref([]);
		let dataListLoading = ref(false);
		let dataListPagination = ref({
			total: 0,
			current: 1,
			showSizeChanger: true,
			showQuickJumper: true,
			defaultPageSize: 20,
			pageSizeOptions: ['20', '50', '100', '200'],
			showTotal: () => '共' + dataListPagination.value.total + '条',
		});
		// 执行查询
		const searchDataList = () => {
			dataListPagination.value.current = 1;
			searchParam.value.pageNum = 1;
			doSearchDataList();
		}
		const handleTablePageChange = (pagination, filters, sorter) => {
			dataListPagination.value.current = pagination.current;
			searchParam.value.pageNum = pagination.current;
			searchParam.value.pageSize = pagination.pageSize;
			doSearchDataList();
		}
		const doSearchDataList = () => {
			dataListLoading.value = true;
			databoardApi.${entity?uncap_first}ListPage(searchParam.value).then(response => {
				// 第一页设置总条数
				if (searchParam.value.pageNum === 1) {
					dataListPagination.value.total = response.data.total;
				}
				dataList.value = response.data.records || [];
				dataListLoading.value = false;
			}).catch(err => {
				dataListLoading.value = false;
				console.log(err.message);
			});
		}
		const deleteDataItem = (row) => {
			Modal.confirm({
				centered: true,
				maskClosable: true,
				icon: createVNode(ExclamationCircleOutlined),
				title: '删除确认',
				content: '你确定要删除此数据吗？',
				cancelText: '取消',
				okText: '删除',
				onOk() {
					databoardApi.${entity?uncap_first}Delete({id: row.id}).then(response => {
						message.success('删除成功');
						searchDataList();
					}).catch(err => {
						console.log(err.message);
					});
				},
			});
		}
		// 展示新建弹窗
		let dataItemEdit = ref({});
		let dataItemEditVisible = ref(false);
		let dataItemEditForm = ref();
		const showCreateModal = () => {
			dataItemEdit.value = {};
			dataItemEditVisible.value = true;
			setTimeout(() => dataItemEditForm.value.resetFields(), 0);
		}
		const editDataItem = (row) => {
			dataItemEditVisible.value = true;
			setTimeout(() => {
				dataItemEditForm.value.resetFields();
				dataItemEdit.value = JSON.parse(JSON.stringify(row));
			}, 0);
		}
		const dataItemEditOk = () => {
			dataItemEditForm.value.validate().then(() => {
				databoardApi.${entity?uncap_first}Save(dataItemEdit.value).then(response => {
					dataItemEditVisible.value = false;
					message.success(!!dataItemEdit.value.id ? "编辑成功" : "创建成功");
					searchDataList();
				}).catch(err => {
					console.log(err.message);
				});
			}).catch(error => {
				console.log('error', error);
			});
		}
		return {
			// 搜索
			searchParam,
			metaGroupList,
			// 列表
			dataList,
			dataListPagination,
			dataListLoading,
			searchDataList,
			handleTablePageChange,
			editDataItem,
			deleteDataItem,
			dataListColumns: [
				{title: 'ID', width: '80px', dataIndex: 'id'},
<#list cfg.columnConfig as tables>
    <#if tables.className == entity>
        <#list tables.columns as column>
				{title: '${column.name}', dataIndex: '${column.column}'},
        </#list>
    </#if>
</#list>
				{title: '更新时间', width: '180px', dataIndex: 'modified'},
				{title: '操作人', width: '120px', dataIndex: 'modifyUser'},
				{title: '操作', width: '130px', fixed: 'right', dataIndex: 'action'},
			],
			// 编辑弹窗
			dataItemEdit,
			dataItemEditVisible,
			dataItemEditForm,
			showCreateModal,
			dataItemEditOk,
			dataItemEditRules: {
<#list cfg.columnConfig as tables>
    <#if tables.className == entity>
        <#list tables.columns as column>
				${column.column}: [{required: true, type: '${column.dataType}', message: '${column.tips}', trigger: 'change'}],
        </#list>
    </#if>
</#list>
			},
		};
	},
};
</script>

<style scoped>
.template-data-list {

}
</style>
