import inspect
import json
import sys


def main():
    func_name = sys.argv[1]
    args_json = sys.argv[2]
    args_from_java = json.loads(args_json)
    target_function = globals().get(func_name)
    if target_function is None:
        return {"code": -1, "msg": f"{func_name} not found."}
    params = inspect.signature(target_function).parameters
    if len(params) != len(args_from_java):
        return {"code": -2, "msg": f"params count not match."}
    missing_keys = [key for key in params if key not in args_from_java]
    if missing_keys:
        return {"code": -3, "msg": f"missing params: {missing_keys}"}
    args_from_java = {k: v for k, v in sorted(args_from_java.items(), key=lambda x: list(params.keys()).index(x[0]))}
    result = target_function(**args_from_java)
    return {"code": 0, "msg": "success", "data": result}


if __name__ == "__main__":
    output = main()
    print(f"[ZY-PY-RESULT]{json.dumps(output)}")
