import argparse
import subprocess
import sys
import re


def install_module(module_name, python_executable):
    try:
        subprocess.check_call([python_executable, "-m", "pip", "install", module_name])
        return True
    except subprocess.CalledProcessError:
        return False


def extract_imports(file_name):
    with open(file_name, 'r') as file:
        file_content = file.read()
        imports = re.findall(r'^(?:from\s+(\S+)|import\s+(\S+))(?:\s+|$)', file_content, re.MULTILINE)
        top_level_modules = {imp[0].split('.')[0] if imp[0] else imp[1].split('.')[0] for imp in imports}
        return list(top_level_modules)


def check_module(module, python_executable):
    try:
        subprocess.check_call([python_executable, "-c", f"import {module}"])
        return True
    except subprocess.CalledProcessError:
        return False


def check_and_install_modules(modules, python_executable):
    for module in modules:
        if check_module(module, python_executable):
            print(f"module '{module}' already exists.")
        else:
            print(f"installing module: {module}")
            if not install_module(module, python_executable):
                print(f"failed to install '{module}'.")


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("script")
    parser.add_argument("-p", "--python-path", default=sys.executable)
    args = parser.parse_args()

    modules_to_check = extract_imports(args.script)
    check_and_install_modules(modules_to_check, args.python_path)


if __name__ == "__main__":
    main()
