
alter table department modify external_id varchar(50) null;
alter table wiki_page_content add column search_content text null;
alter table wiki_page_version add column search_content text null;
alter table ai_page_segment add column search_content text null;
alter table user_setting modify value mediumtext null;

CREATE TABLE `ai_third_party_config` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `config_name` varchar(100) NULL DEFAULT NULL,
    `config_type` tinyint not null,
    `config_id` bigint null,
    `third_party_type` tinyint not null,
    `app_key` varchar(100) NULL DEFAULT NULL,
    `app_secret` varchar(256) NULL DEFAULT NULL,
    `app_token` varchar(100) NULL DEFAULT NULL,
    `app_aes_key` varchar(100) NULL DEFAULT NULL,
    `corp_id` varchar(100) NULL DEFAULT NULL,
    `card_template_id` varchar(100) NULL DEFAULT NULL,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `modify_user_id` bigint null,
    `modify_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_config` (`config_type`, `config_id`),
    UNIQUE INDEX `idx_app_key`(`app_key`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_tags` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `parent_id` bigint(20) NOT NULL DEFAULT 0,
    `tag_type` tinyint not null,
    `tag_name` varchar(20) NULL DEFAULT NULL,
    `tag_color` varchar(20) NULL DEFAULT NULL,
    `tag_icon` varchar(20) NULL DEFAULT NULL,
    `space_id` bigint null,
    `seq_no` int(11) NOT NULL DEFAULT 0,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `modify_user_id` bigint null,
    `modify_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tag_type` (`tag_type`),
    INDEX `idx_type_space` (`tag_type`, `space_id`),
    INDEX `idx_type_user` (`tag_type`, `create_user_id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_page_tags` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `tag_id` bigint null,
    `space_id` bigint null,
    `page_id` bigint null,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `idx_tag_page`(`tag_id`, `space_id`, `page_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

