
alter table wiki_page add column `quote_page_id` bigint NULL;
alter table wiki_webhook_config add column `notify_Source` varchar(50) NULL;
alter table ai_app_chat add column `create_user_id` bigint null;
alter table ai_app_chat add column `create_user` varchar(50) null;

CREATE TABLE `ai_inner_chat` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `user_uuid` varchar(50) NULL DEFAULT NULL,
    `chat_uuid` varchar(50) NULL DEFAULT NULL,
    `abstract_title` varchar(128) NULL DEFAULT NULL,
    `chat_num` int default 0 not null,
    `usage_tokens` int default 0 not null,
    `new_user_flag` tinyint default 0 not null,
    `space_uuid` varchar(50) DEFAULT NULL,
    `space_id` bigint null,
    `integrate_uuid` varchar(50) DEFAULT NULL,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_user_uuid` (`user_uuid`),
    INDEX `idx_user_id` (`create_user_id`),
    UNIQUE INDEX `idx_chat_uuid`(`chat_uuid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_inner_chat_msg` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `chat_id` bigint(20) NOT NULL,
    `source_pages` text null,
    `use_time` double null,
    `usage_tokens` int null,
    `question` varchar(256) null,
    `answer` text null,
    `prompt` text null,
    `created` datetime null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_chat_id` (`chat_id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_inner_statistic` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `user_uuid` varchar(50) NULL DEFAULT NULL,
    `chat_uuid` varchar(50) NULL DEFAULT NULL,
    `chat_num` int default 0 not null,
    `usage_tokens` int default 0 not null,
    `new_user_flag` tinyint default 0 not null,
    `dt` int not null,
    PRIMARY KEY (`id`),
    UNIQUE INDEX idx_user_chat_dt(user_uuid, chat_uuid, dt),
    INDEX `idx_user_uuid` (`user_uuid`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
