
alter table user_message add index idx_affect_user_id(affect_user_id);

CREATE TABLE `page_view_log` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `space_id` bigint(20) default null,
    `page_id` bigint(20) not null,
    `created` datetime null,
    `view_source` tinyint default 1 not null,
    `view_user_id` varchar(50) null,
    `view_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_page_id`(`space_id`, `page_id`, `view_user_id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `page_action_log` (
    `id` bigint(20) not null auto_increment,
    `space_id` bigint(20) default null,
    `page_id` bigint(20) not null,
    `action_type` tinyint default 0 not null,

    `auth_type` tinyint default 0 not null,
    `target_dept_id` bigint(20) null default null,
    `target_dept_name` varchar(50) null,
    `target_user_id` bigint(20) null default null,
    `target_user_name` varchar(50) null,
    `include_children_dept` tinyint default 0 not null,
    `include_children_page` tinyint default 0 not null,

    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_page_id`(`page_id`, `action_type`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
