CREATE TABLE `ai_application` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `uuid` varchar(50) NULL DEFAULT NULL,
    `app_name` varchar(50) NULL DEFAULT NULL,
    `app_desc` varchar(256) NULL DEFAULT NULL,
    `prompt_text` varchar(1024) NULL DEFAULT NULL,
    `prologue_text` varchar(1024) NULL DEFAULT NULL,
    `space_ids` varchar(100) NULL DEFAULT NULL,
    `chat_icon` varchar(256) NULL DEFAULT NULL,
    `entrance_icon` varchar(256) NULL DEFAULT NULL,
    `no_ref_answer` varchar(256) NULL DEFAULT NULL,
    `share_status` tinyint default 0 not null,
    `login_required` tinyint default 0 not null,
    `display_language` varchar(10) NULL DEFAULT NULL,
    `develop_mode` tinyint default 1 not null,
    `flow_content` mediumtext NULL,

    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `modify_user_id` bigint null,
    `modify_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `idx_uuid`(`uuid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_app_chat` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `app_id` bigint(20) NOT NULL,
    `user_uuid` varchar(50) NULL DEFAULT NULL,
    `chat_uuid` varchar(50) NULL DEFAULT NULL,
    `abstract_title` varchar(128) NULL DEFAULT NULL,
    `chat_num` int default 0 not null,
    `usage_tokens` int default 0 not null,
    `new_user_flag` tinyint default 0 not null,

    `created` datetime null,
    `modified` datetime null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_app_id` (`app_id`),
    INDEX `idx_user_uuid` (`user_uuid`),
    UNIQUE INDEX `idx_chat_uuid`(`chat_uuid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_app_chat_msg` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `chat_id` bigint(20) NOT NULL,
    `source_pages` varchar(1024) null,
    `use_time` double null,
    `usage_tokens` int null,
    `question` varchar(256) null,
    `answer` text null,
    `logic_flow` mediumtext NULL,

    `created` datetime null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_chat_id` (`chat_id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_app_statistic` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `app_id` bigint(20) NOT NULL,
    `user_uuid` varchar(50) NULL DEFAULT NULL,
    `chat_uuid` varchar(50) NULL DEFAULT NULL,
    `chat_num` int default 0 not null,
    `usage_tokens` int default 0 not null,
    `new_user_flag` tinyint default 0 not null,
    `dt` int not null,
    PRIMARY KEY (`id`),
    UNIQUE INDEX idx_space_page_user_dt(app_id, user_uuid, chat_uuid, dt),
    INDEX `idx_app_id` (`app_id`),
    INDEX `idx_user_uuid` (`app_id`, `user_uuid`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_app_function` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `func_name` varchar(50) NULL DEFAULT NULL,
    `func_desc` varchar(100) NULL DEFAULT NULL,
    `visible_rang` tinyint default 0 not null,
    `func_main` varchar(100) NULL DEFAULT NULL,
    `func_code` text NULL DEFAULT NULL,
    `func_params` varchar(1024) NULL DEFAULT NULL,

    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `modify_user_id` bigint null,
    `modify_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

alter table wiki_page_file add column data_id bigint(20) NULL;
alter table wiki_page_file add column file_origin int null;

INSERT INTO `auth_info` (auth_name, auth_desc, can_edit, create_uid, creation_time, auth_type)
VALUES ('AI_APP_MANAGE', 'AI应用管理权', 0, 1, '2024-08-15 15:26:17', 1);
