
CREATE TABLE `wiki_api_environment`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`space_id` bigint not null,
	`environment_name` varchar(20) null,
	`seq_no` int NOT NULL DEFAULT 0,
	`share_env` tinyint default 0 not null,

	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE,
	INDEX idx_source_id(space_id) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_api_service`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`space_id` bigint not null,
	`service_name` varchar(50) null,
	`seq_no` int NOT NULL DEFAULT 0,
	`system_flag` int NOT NULL DEFAULT 0,

	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE,
	INDEX idx_source_id(space_id) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_api_env_service`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`space_id` bigint not null,
	`service_id` bigint not null,
	`environment_id` bigint not null,
	`service_url` varchar(100) null,

	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE,
	INDEX idx_source_id(space_id) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
