
create index idx_space_id on wiki_page(space_id);

alter table wiki_space add column version_control tinyint default 0 not null;
alter table wiki_integrate add column version_control tinyint default 0 not null;

CREATE TABLE `wiki_version_control`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`source_id` bigint not null,
	`source_type` tinyint not null,
	`version_name` varchar(20) null,

	`logo_url` varchar(200) DEFAULT NULL,
	`integrate_title` varchar(50) DEFAULT NULL,
	`home_page_content` mediumtext DEFAULT NULL,
	`menu_content` mediumtext DEFAULT NULL,
	`statistics_key` varchar(50) NULL DEFAULT NULL,
	`show_home_page` tinyint default 0 not null,

	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE,
	INDEX idx_source_id(source_id, source_type) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_page_version`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`version_id` bigint(20) NULL DEFAULT NULL,
	`page_id` bigint(20) NULL DEFAULT NULL,
	`space_id` bigint(20) NULL DEFAULT NULL,
	`parent_id` bigint(20) NOT NULL DEFAULT 0,
	`name` varchar(50) NULL DEFAULT NULL,
	`seq_no` int(11) NOT NULL DEFAULT 0,
	`editor_type` tinyint(4) NOT NULL DEFAULT 1,
	`content` mediumtext NULL,
	`preview` mediumtext NULL,

	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE,
	INDEX idx_version_space(version_id, space_id) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
