-- ------------------------------------------------
-- 版本升级增量建表脚本
-- ------------------------------------------------

-- 每次发版时注意事项 ---
-- 1. datetime(0) 低版本不支持此语法，改为datetime
-- 2. utf8mb4 低版本不支持此字符集，改为utf8
-- 3. 加字段后记得排查是否有insert语句，需要同步修改

-- ------------------------从2.0.3版本升级------------------------

CREATE TABLE `wiki_statistics_action_flow` (
	id bigint(20) NOT NULL AUTO_INCREMENT,
	user_id bigint not null,
	space_id bigint not null,
	page_id bigint not null,
	create_page_num int not null default 0,
	update_page_num int not null default 0,
	visit_count int not null default 0,
	zan_num int not null default 0,
	favorite_num int not null default 0,
	comment_num int not null default 0,
	dt int not null,
	PRIMARY KEY (`id`),
	UNIQUE INDEX idx_space_page_user_dt(user_id, space_id, page_id, dt),
	INDEX idx_dt(dt) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_statistics_total_dt` (
	id bigint(20) NOT NULL AUTO_INCREMENT,
	space_id bigint not null,
	total_page_num int not null default 0,
	create_page_num int not null default 0,
	update_page_num int not null default 0,
	visit_user_num int not null default 0,
	visit_count int not null default 0,
	comment_num int not null default 0,
	zan_num int not null default 0,
	favorite_num int not null default 0,
	dt int not null,
	show_dt varchar(30) not null,
	PRIMARY KEY (`id`),
	UNIQUE INDEX idx_space_dt(space_id, dt),
	INDEX idx_dt(dt) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_statistics_page_dt` (
	id bigint(20) NOT NULL AUTO_INCREMENT,
	space_id bigint not null,
	page_id bigint not null,
	page_name varchar(50) not null,
	visit_user_num int not null default 0,
	visit_count int not null default 0,
	comment_num int not null default 0,
	zan_num int not null default 0,
	favorite_num int not null default 0,
	dt int not null,
	show_dt varchar(30) not null,
	PRIMARY KEY (`id`),
	UNIQUE INDEX idx_space_page_dt(space_id, page_id, dt),
	INDEX idx_dt(dt) USING BTREE,
	INDEX idx_space_dt(space_id, dt) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_statistics_user_dt` (
	id bigint(20) NOT NULL AUTO_INCREMENT,
	space_id bigint not null,
	user_id bigint not null,
	user_name varchar(50) not null,
	create_page_num int not null default 0,
	update_page_num int not null default 0,
	visit_page_num int not null default 0,
	visit_count int not null default 0,
	zan_num int not null default 0,
	favorite_num int not null default 0,
	comment_num int not null default 0,
	received_visit_page_num int not null default 0,
	received_visit_count int not null default 0,
	received_zan_num int not null default 0,
	received_favorite_num int not null default 0,
	received_comment_num int not null default 0,
	dt int not null,
	show_dt varchar(30) not null,
	PRIMARY KEY (`id`),
	UNIQUE INDEX idx_space_user_dt(space_id, user_id, dt),
	INDEX idx_dt(dt) USING BTREE,
	INDEX idx_space_dt(space_id, dt) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;


