-- ------------------------------------------------
-- 版本升级增量建表脚本
-- ------------------------------------------------

-- 每次发版时注意事项 ---
-- 1. datetime(0) 低版本不支持此语法，改为datetime
-- 2. utf8mb4 低版本不支持此字符集，改为utf8
-- 3. 加字段后记得排查是否有insert语句，需要同步修改

-- ------------------------从1.1.0版本升级------------------------

CREATE TABLE `wiki_page_favorite` (
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`space_id` bigint(20) DEFAULT NULL,
	`page_id` bigint(20) DEFAULT NULL,
	`user_id` bigint(20) DEFAULT NULL,
	`favorite` tinyint(4) NOT NULL DEFAULT '0',
	`create_time` datetime DEFAULT NULL,
	PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `user_data_auth` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`user_id` BIGINT(20) NULL DEFAULT NULL,
	`sys_type` INT(11) NULL DEFAULT NULL,
	`sys_module_type` INT(11) NULL DEFAULT NULL,
	`sys_module_id` BIGINT(20) NULL DEFAULT NULL,
	`create_uid` BIGINT(20) NULL DEFAULT NULL,
	`update_uid` BIGINT(20) NULL DEFAULT NULL,
	`creation_time` DATETIME NULL DEFAULT NULL,
	`update_time` DATETIME NULL DEFAULT NULL,
	`del_flag` TINYINT(4) NULL DEFAULT '0',
	KEY `idx_sys_module` (`user_id`, `sys_type`, `sys_module_type`, `sys_module_id`),
	PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `department` (
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`parent_id` bigint(20) DEFAULT NULL,
	`department_name` varchar(50) DEFAULT NULL,
	`department_desc` varchar(100) DEFAULT NULL,
	`seq_no` int(11) DEFAULT NULL,
	`create_user_id` bigint(20) DEFAULT NULL,
	`create_user_name` varchar(20) DEFAULT NULL,
	`create_time` datetime DEFAULT NULL,
	`yn` tinyint(4) DEFAULT NULL,
	PRIMARY KEY (`id`),
	KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- 修改空间类型为空间成员可见
update `wiki_space` set `type`=2 where `type`=3;
-- 增加字段
ALTER TABLE `wiki_page_file` ADD COLUMN `space_id` bigint(20) DEFAULT NULL;
ALTER TABLE `wiki_page_file` ADD COLUMN `file_source` TINYINT(4) NOT NULL DEFAULT '1';
ALTER TABLE `wiki_space` ADD COLUMN `logo_url` varchar(200) DEFAULT NULL;
ALTER TABLE `wiki_space` ADD COLUMN `cover_url` varchar(200) DEFAULT NULL;
ALTER TABLE `user_info` ADD COLUMN `department_id` bigint(20) NOT NULL DEFAULT 0;
ALTER TABLE `user_data_auth` ADD COLUMN `department_id` BIGINT(20) DEFAULT NULL;

