-- ------------------------------------------------
-- 全量建表脚本
-- ------------------------------------------------

SET NAMES utf8mb4;

CREATE TABLE `auth_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `auth_name` varchar(50) NULL DEFAULT NULL,
  `auth_desc` varchar(100) NULL DEFAULT NULL,
  `can_edit` tinyint(4) NULL DEFAULT 1,
  `create_uid` bigint(20) NULL DEFAULT NULL,
  `creation_time` datetime NULL DEFAULT NULL,
  `auth_type` tinyint(4) NOT NULL DEFAULT 0,
  UNIQUE INDEX idx_auth_name(auth_name),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 30 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `user_auth`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NULL DEFAULT NULL,
  `auth_id` bigint(20) NULL DEFAULT NULL,
  `create_uid` bigint(20) NULL DEFAULT NULL,
  `update_uid` bigint(20) NULL DEFAULT NULL,
  `del_flag` tinyint(4) NULL DEFAULT 0,
  `creation_time` datetime NULL DEFAULT NULL,
  `update_time` datetime NULL DEFAULT NULL,
  `sys_type` int NULL,
  `sys_module_type` int NULL,
  `sys_module_id` bigint(20) NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX idx_user (user_id, del_flag)
) ENGINE = InnoDB AUTO_INCREMENT = 10 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `user_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_no` varchar(50) NULL DEFAULT NULL,
  `password` varchar(50) NULL DEFAULT NULL,
  `user_name` varchar(50) NULL DEFAULT NULL,
  `email` varchar(50) NULL DEFAULT NULL,
  `avatar` varchar(256) NULL DEFAULT NULL,
  `del_flag` tinyint(4) NOT NULL DEFAULT 0,
  `creation_time` datetime NULL DEFAULT NULL,
  `create_uid` bigint(20) NULL DEFAULT NULL,
  `update_time` datetime NULL DEFAULT NULL,
  `phone` varchar(20) NULL DEFAULT NULL,
  `sex` tinyint(4) NOT NULL DEFAULT 0,
  `department_id` bigint(20) NOT NULL DEFAULT 0,
  `parent_department_ids` varchar(100) NULL DEFAULT NULL,
  `user_status` tinyint(4) NOT NULL DEFAULT 1,
  `verify_code` varchar(50) NULL,
  `send_code_time` datetime NULL,
  `language` varchar(10) null,
  `user_desc` varchar(256) NULL,
  `last_login_time` datetime NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `idx_userNo`(`user_no`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_page`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `space_id` bigint(20) NULL DEFAULT NULL,
  `name` varchar(256) NULL DEFAULT NULL,
  `parent_id` bigint(20) NOT NULL DEFAULT 0,
  `node_type` tinyint(4) NULL DEFAULT 0,
  `zan_num` int(11) NOT NULL DEFAULT 0,
  `edit_type` tinyint(4) NOT NULL DEFAULT 0,
  `create_user_id` bigint(20) NULL DEFAULT NULL,
  `create_user_name` varchar(20) NULL DEFAULT NULL,
  `create_time` datetime NULL DEFAULT NULL,
  `update_user_id` bigint(20) NULL DEFAULT NULL,
  `update_user_name` varchar(20) NULL DEFAULT NULL,
  `update_time` datetime NULL DEFAULT NULL,
  `del_flag` tinyint(4) NOT NULL DEFAULT 0,
  `view_num` int(11) NOT NULL DEFAULT 0,
  `seq_no` int(11) NOT NULL DEFAULT 0,
  `editor_type` tinyint(4) NOT NULL DEFAULT 1,
  `uuid` varchar(40) NULL DEFAULT NULL,
  `share_flag` tinyint(4) NOT NULL DEFAULT 0,
  `share_password` varchar(20) NULL DEFAULT NULL,
  `share_include_children` tinyint default 0 not null,
  `share_expiration_date` datetime DEFAULT NULL,
  `file_extension` varchar(20) NULL DEFAULT NULL,
  `from_page_id` bigint default null,
  `ai_page_id` varchar(50) DEFAULT NULL,
  `release_status` tinyint(4) NULL DEFAULT 0,
  `quote_page_id` bigint NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uni_uuid` (`uuid`),
  INDEX `idx_space_id`(`space_id`) USING BTREE,
  INDEX `idx_quote_page_id`(`quote_page_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_page_comment`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `page_id` bigint(20) NULL DEFAULT NULL,
  `parent_id` bigint(20) NULL DEFAULT NULL,
  `content` text NULL DEFAULT NULL,
  `zan_num` int(11) NOT NULL DEFAULT 0,
  `create_user_id` bigint(20) NULL DEFAULT NULL,
  `create_user_name` varchar(20) NULL DEFAULT NULL,
  `create_time` datetime NULL DEFAULT NULL,
  `del_flag` tinyint(4) NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  index idx_page_id(page_id)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_page_content`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `page_id` bigint(20) NULL DEFAULT NULL,
  `content` mediumtext NULL,
  `create_user_id` bigint(20) NULL DEFAULT NULL,
  `create_user_name` varchar(20) NULL DEFAULT NULL,
  `create_time` datetime NULL DEFAULT NULL,
  `update_user_id` bigint(20) NULL DEFAULT NULL,
  `update_user_name` varchar(20) NULL DEFAULT NULL,
  `update_time` datetime NULL DEFAULT NULL,
  `preview` mediumtext NULL DEFAULT NULL,
  `space_id` bigint(20) NULL,
  `edit_content` mediumtext NULL,
  `search_content` text NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uk_page_id`(`page_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_page_file`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `space_id` bigint(20) DEFAULT NULL,
  `page_id` bigint(20) NULL DEFAULT NULL,
  `file_name` varchar(256) NULL DEFAULT NULL,
  `file_url` varchar(512) NULL DEFAULT NULL,
  `uuid` varchar(40) NULL DEFAULT NULL,
  `create_user_id` bigint(20) NULL DEFAULT NULL,
  `create_user_name` varchar(20) NULL DEFAULT NULL,
  `create_time` datetime NULL DEFAULT NULL,
  `update_user_id` bigint(20) NULL DEFAULT NULL,
  `update_user_name` varchar(20) NULL DEFAULT NULL,
  `update_time` datetime NULL DEFAULT NULL,
  `del_flag` tinyint(4) NULL DEFAULT 0,
  `download_num` int(11) NOT NULL DEFAULT 0,
  `file_size` bigint NULL,
  `file_source` TINYINT(4) NOT NULL DEFAULT '1',
  `storage_type` tinyint not NULL default 1,
  `integrate_id` bigint(20) DEFAULT NULL,
  `object_path` varchar(512) NULL DEFAULT NULL,
  `data_id` bigint(20) NULL,
  `file_origin` int null,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uk_uuid`(`uuid`) USING BTREE,
  index idx_space_page(space_id, page_id, del_flag)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_page_history`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `page_id` bigint(20) NULL DEFAULT NULL,
  `create_user_id` bigint(20) NULL DEFAULT NULL,
  `create_user_name` varchar(20) NULL DEFAULT NULL,
  `create_time` datetime NULL DEFAULT NULL,
  `del_flag` tinyint(4) NOT NULL DEFAULT 0,
  `name` varchar(256) NULL DEFAULT NULL,
  `content` mediumblob null,
  `preview` mediumblob null,
  `description` varchar(256) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_page_id`(`page_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_page_zan`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `page_id` bigint(20) NULL DEFAULT NULL,
  `comment_id` bigint(20) NULL DEFAULT NULL,
  `create_user_id` bigint(20) NULL DEFAULT NULL,
  `create_user_name` varchar(20) NULL DEFAULT NULL,
  `create_time` datetime NULL DEFAULT NULL,
  `yn` tinyint(4) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  index idx_page (page_id, yn)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_space`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NULL DEFAULT NULL,
  `type` tinyint(4) NULL DEFAULT 1,
  `uuid` varchar(40) NULL DEFAULT NULL,
  `space_explain` varchar(255) NULL DEFAULT NULL,
  `logo_url` varchar(512) DEFAULT NULL,
  `cover_url` varchar(512) DEFAULT NULL,
  `edit_type` tinyint(4) NOT NULL DEFAULT 0,
  `tree_lazy_load` tinyint(4) NOT NULL DEFAULT 0,
  `open_doc` tinyint(4) NOT NULL DEFAULT 0,
  `annex_open_type` tinyint default 1 not null,
  `statistics_key` varchar(50) NULL DEFAULT NULL,
  `create_user_id` bigint(20) NULL DEFAULT NULL,
  `create_user_name` varchar(20) NULL DEFAULT NULL,
  `create_time` datetime NULL DEFAULT NULL,
  `del_flag` tinyint(4) NOT NULL DEFAULT 0,
  `group_id` bigint(20) NOT NULL DEFAULT 0,
  `seq_no` int NOT NULL DEFAULT 999,
  `share_enable_password` tinyint default 0 not null,
  `share_password` varchar(20) NULL DEFAULT NULL,
  `share_password_tips` text NULL DEFAULT NULL,
  `share_enable_probation` tinyint default 0 not null,
  `share_probation_ids` varchar(1024) NULL DEFAULT NULL,
  `share_enable_payment` tinyint default 0 not null,
  `share_price` bigint(20) NULL DEFAULT NULL,
  `share_single_visit` tinyint default 0 not null,
  `share_allow_use_num` int default 0 not null,
  `share_expiry_day` int default 0 not null,
  `version_control` tinyint default 0 not null,
  `viewer_allowed_export` tinyint default 2 not null,
  `share_display` text DEFAULT NULL,
  `copy_control` tinyint default 0 not null,
  `copy_control_line` int NULL DEFAULT NULL,
  `global_variables` text NULL DEFAULT NULL,
  `ai_kb_id` varchar(50) DEFAULT NULL,
  `ai_sync_enable` tinyint default 0 not null,
  `cover_color_type` tinyint(4) NULL,
  `release_control` tinyint(4) NULL DEFAULT 0,
  `new_page_position` tinyint(4) NULL DEFAULT 1,
  `modified` datetime null,
  `modify_user_id` bigint null,
  `modify_user` varchar(50) null,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `idx_uuid`(`uuid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `user_message`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sys_type` tinyint(4) NOT NULL DEFAULT 1,
  `msg_type` int NOT NULL DEFAULT 1,
  `data_id` bigint(20) NULL DEFAULT NULL,
  `data_desc` varchar(100) NULL DEFAULT NULL,
  `msg_content` varchar(255) NULL DEFAULT NULL,
  `msg_status` tinyint(4) NOT NULL DEFAULT 0,
  `operator_user_id` bigint(20) NULL DEFAULT NULL,
  `operator_user_name` varchar(20) NULL DEFAULT NULL,
  `affect_user_id` bigint(20) NULL DEFAULT NULL,
  `affect_user_name` varchar(20) NULL DEFAULT NULL,
  `accept_user_id` bigint(20) NULL DEFAULT NULL,
  `creation_time` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_affect_user_id` (affect_user_id, msg_status)
) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_space_favorite` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `space_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `del_flag` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  index idx_user_id (user_id, del_flag)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `user_setting` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `value` mediumtext DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `del_flag` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  index idx_user_id (user_id, del_flag)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_page_favorite` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `space_id` bigint(20) DEFAULT NULL,
  `page_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `favorite` tinyint(4) NOT NULL DEFAULT '0',
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  index idx_user_id (user_id, space_id, favorite)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `user_data_auth` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `user_id` BIGINT(20) NULL DEFAULT NULL,
  `department_id` BIGINT(20) NULL DEFAULT NULL,
  `sys_type` INT(11) NULL DEFAULT NULL,
  `sys_module_type` INT(11) NULL DEFAULT NULL,
  `sys_module_id` BIGINT(20) NULL DEFAULT NULL,
  `include_children` tinyint default 0 not null,
  `include_children_page` tinyint default 0 not null,
  `space_id` bigint null,
  `expiration_time` datetime null,
  `create_uid` BIGINT(20) NULL DEFAULT NULL,
  `update_uid` BIGINT(20) NULL DEFAULT NULL,
  `creation_time` DATETIME NULL DEFAULT NULL,
  `update_time` DATETIME NULL DEFAULT NULL,
  `del_flag` TINYINT(4) NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_sys_module` (`user_id`, `sys_type`, `sys_module_type`, `sys_module_id`),
  INDEX idx_user (user_id, del_flag),
  INDEX idx_dept (department_id, del_flag),
  INDEX idx_space (space_id, del_flag)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `department` (
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`parent_id` bigint(20) DEFAULT NULL,
    `external_id` varchar(50) null,
	`department_name` varchar(50) DEFAULT NULL,
	`department_desc` varchar(100) DEFAULT NULL,
	`seq_no` int(11) DEFAULT NULL,
	`create_user_id` bigint(20) DEFAULT NULL,
	`create_user_name` varchar(20) DEFAULT NULL,
	`create_time` datetime DEFAULT NULL,
	`yn` tinyint(4) DEFAULT NULL,
	PRIMARY KEY (`id`),
	KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_page_template` (
	id bigint(20) NOT NULL AUTO_INCREMENT,
	space_id bigint null,
	page_id bigint null,
	tag_name varchar(50) null,
	share_status tinyint default 0 not null,

	created datetime null,
	create_user_id bigint null,
	create_user varchar(50) null,
	modified datetime null,
	modify_user_id bigint null,
	modify_user varchar(50) null,
	yn tinyint default 1 not null,
	PRIMARY KEY (`id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `system_config` (
	id bigint(20) NOT NULL AUTO_INCREMENT,
	config_key varchar(100) null,
	config_value text null,

	created datetime null,
	create_user_id bigint null,
	create_user varchar(50) null,
	modified datetime null,
	modify_user_id bigint null,
	modify_user varchar(50) null,
	yn tinyint default 1 not null,
	UNIQUE INDEX idx_config_key(config_key),
	PRIMARY KEY (`id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_statistics_action_flow` (
	id bigint(20) NOT NULL AUTO_INCREMENT,
	user_id bigint not null,
	space_id bigint not null,
	page_id bigint not null,
	create_page_num int not null default 0,
	update_page_num int not null default 0,
	visit_count int not null default 0,
	zan_num int not null default 0,
	favorite_num int not null default 0,
	comment_num int not null default 0,
	dt int not null,
	PRIMARY KEY (`id`),
	UNIQUE INDEX idx_space_page_user_dt(user_id, space_id, page_id, dt),
	INDEX idx_dt(dt) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_statistics_total_dt` (
	id bigint(20) NOT NULL AUTO_INCREMENT,
	space_id bigint not null,
	total_page_num int not null default 0,
	create_page_num int not null default 0,
	update_page_num int not null default 0,
	visit_user_num int not null default 0,
	visit_count int not null default 0,
	comment_num int not null default 0,
	zan_num int not null default 0,
	favorite_num int not null default 0,
	dt int not null,
	show_dt varchar(30) not null,
	PRIMARY KEY (`id`),
	UNIQUE INDEX idx_space_dt(space_id, dt),
	INDEX idx_dt(dt) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_statistics_page_dt` (
	id bigint(20) NOT NULL AUTO_INCREMENT,
	space_id bigint not null,
	page_id bigint not null,
	page_name varchar(256) not null,
	visit_user_num int not null default 0,
	visit_count int not null default 0,
	comment_num int not null default 0,
	zan_num int not null default 0,
	favorite_num int not null default 0,
	dt int not null,
	show_dt varchar(30) not null,
	PRIMARY KEY (`id`),
	UNIQUE INDEX idx_space_page_dt(space_id, page_id, dt),
	INDEX idx_dt(dt) USING BTREE,
	INDEX idx_space_dt(space_id, dt) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_statistics_user_dt` (
	id bigint(20) NOT NULL AUTO_INCREMENT,
	space_id bigint not null,
	user_id bigint not null,
	user_name varchar(50) not null,
	create_page_num int not null default 0,
	update_page_num int not null default 0,
	visit_page_num int not null default 0,
	visit_count int not null default 0,
	zan_num int not null default 0,
	favorite_num int not null default 0,
	comment_num int not null default 0,
	received_visit_page_num int not null default 0,
	received_visit_count int not null default 0,
	received_zan_num int not null default 0,
	received_favorite_num int not null default 0,
	received_comment_num int not null default 0,
	dt int not null,
	show_dt varchar(30) not null,
	PRIMARY KEY (`id`),
	UNIQUE INDEX idx_space_user_dt(space_id, user_id, dt),
	INDEX idx_dt(dt) USING BTREE,
	INDEX idx_space_dt(space_id, dt) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_share_comment`  (
	id bigint(20) NOT NULL AUTO_INCREMENT,
	space_id bigint(20) NULL DEFAULT NULL,
	page_id bigint(20) NULL DEFAULT NULL,
	select_text varchar(1024) NULL DEFAULT NULL,
	comment_url varchar(256) NULL DEFAULT NULL,
	integrate_uuid varchar(50) NULL DEFAULT NULL,
	feedback_type tinyint default 1 not null,
	comment_text varchar(500) NULL DEFAULT NULL,
	process_status tinyint default 0 not null,
	created datetime null,
	PRIMARY KEY (id),
	INDEX idx_space_id(space_id) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_integrate`  (
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`integrate_status` tinyint default 1 not null,
	`integrate_name` varchar(50) NULL DEFAULT NULL,
	`integrate_desc` varchar(100) NULL DEFAULT NULL,
	`uuid` varchar(100) NULL DEFAULT NULL,
	`space_uuid` varchar(1024) NULL DEFAULT NULL,
	`charge_user_id` bigint(20) NULL DEFAULT NULL,
	`charge_user_name` varchar(20) NULL DEFAULT NULL,
	`logo_url` varchar(512) DEFAULT NULL,
	`integrate_title` varchar(50) DEFAULT NULL,
	`home_page_content` mediumtext DEFAULT NULL,
	`menu_content` mediumtext DEFAULT NULL,
	`statistics_key` varchar(50) NULL DEFAULT NULL,
	`show_home_page` tinyint default 0 not null,
	`share_enable_password` tinyint default 0 not null,
	`share_password` varchar(20) NULL DEFAULT NULL,
	`share_password_tips` text NULL DEFAULT NULL,
	`share_enable_probation` tinyint default 0 not null,
	`share_enable_payment` tinyint default 0 not null,
	`share_price` bigint(20) NULL DEFAULT NULL,
	`share_single_visit` tinyint default 0 not null,
	`share_allow_use_num` int default 0 not null,
	`share_expiry_day` int default 0 not null,
	`version_control` tinyint default 0 not null,
	`ad_enable` tinyint default 0 not null,
	`ad_list` text null,
    `display_setting` text null,
	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE,
	UNIQUE INDEX `idx_uuid`(`uuid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_domain_mapping`  (
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`visit_domain` varchar(50) NULL DEFAULT NULL,
	`mapping_type` tinyint default 1 not null,
	`mapping_id` bigint(20) NULL DEFAULT NULL,
	`mapping_uuid` varchar(40) NULL DEFAULT NULL,
	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE,
	UNIQUE INDEX `idx_visit_domain`(`visit_domain`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_space_group`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`group_name` varchar(100) NULL DEFAULT NULL,
	`seq_no` int NOT NULL DEFAULT 999,
	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_custom_component`  (
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`component_code` varchar(50) NULL DEFAULT NULL,
	`component_name` varchar(50) NULL DEFAULT NULL,
	`component_desc` varchar(256) NULL DEFAULT NULL,
	`component_content` text NULL DEFAULT NULL,
	`component_status` tinyint default 1 not null,
	`template_code` varchar(512) NULL DEFAULT NULL,
	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_dynamic_password`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`source_id` bigint not null,
	`source_type` tinyint not null,
	`password_desc` varchar(256) NULL DEFAULT NULL,
	`share_password` varchar(50) NULL DEFAULT NULL,
	`single_visit` tinyint default 0 not null,
	`allow_use_num` int default 0 not NULL,
	`used_num` int default 0 not NULL,
	`expiry_day` int default 0 not NULL,
	`source_from` tinyint(4) NOT NULL DEFAULT 1,
	`order_no` varchar(50) NULL DEFAULT NULL,
	`order_status` tinyint default 1 not null,
	`ware_name` varchar(100) null,
	`ware_price` bigint null,
	`ware_password` varchar(500) null,
	`ware_payment_info` varchar(1024) null,
	`visit_ip` varchar(50) null,
	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE,
	INDEX idx_source_id(source_id, source_type) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_dynamic_password_visit`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`dynamic_password_id` bigint not null,
	`visit_ip` varchar(50) null,
	`created` datetime null,
	PRIMARY KEY (`id`) USING BTREE,
	INDEX idx_dynamic_password_id(dynamic_password_id) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_version_control`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`source_id` bigint not null,
	`source_type` tinyint not null,
	`version_name` varchar(20) null,
	`logo_url` varchar(512) DEFAULT NULL,
	`integrate_title` varchar(50) DEFAULT NULL,
	`home_page_content` mediumtext DEFAULT NULL,
	`menu_content` mediumtext DEFAULT NULL,
	`statistics_key` varchar(50) NULL DEFAULT NULL,
	`show_home_page` tinyint default 0 not null,
	`space_uuid` varchar(1024) NULL DEFAULT NULL,
	`target_version_id` bigint DEFAULT NULL,
	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE,
	INDEX idx_source_id(source_id, source_type) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_page_version`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`version_id` bigint(20) NULL DEFAULT NULL,
	`page_id` bigint(20) NULL DEFAULT NULL,
	`space_id` bigint(20) NULL DEFAULT NULL,
	`parent_id` bigint(20) NOT NULL DEFAULT 0,
	`name` varchar(256) NULL DEFAULT NULL,
	`seq_no` int(11) NOT NULL DEFAULT 0,
	`editor_type` tinyint(4) NOT NULL DEFAULT 1,
	`content` mediumtext NULL,
	`preview` mediumtext NULL,
    `search_content` text NULL,
	`file_extension` varchar(20) NULL DEFAULT NULL,
	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE,
	INDEX idx_version_space(version_id, space_id) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_api_environment`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`space_id` bigint not null,
	`environment_name` varchar(20) null,
	`seq_no` int NOT NULL DEFAULT 0,
	`share_env` tinyint default 0 not null,

	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE,
	INDEX idx_source_id(space_id) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_api_service`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`space_id` bigint not null,
	`service_name` varchar(50) null,
	`seq_no` int NOT NULL DEFAULT 0,
	`system_flag` int NOT NULL DEFAULT 0,

	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE,
	INDEX idx_source_id(space_id) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_api_env_service`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`space_id` bigint not null,
	`service_id` bigint not null,
	`environment_id` bigint not null,
	`service_url` varchar(100) null,

	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE,
	INDEX idx_source_id(space_id) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_answer_record`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`question` text null,
	`answer` text null,
	`source_pages` varchar(1024) null,
	`space_id` bigint null,
	`space_uuid` varchar(40) NULL,
	`integrate_uuid` varchar(40) NULL,
	`question_from` tinyint default 0 not null,

	`created` datetime null,
	`create_user_id` bigint null,
	`create_user` varchar(50) null,
	`modified` datetime null,
	`modify_user_id` bigint null,
	`modify_user` varchar(50) null,
	`yn` tinyint default 1 not null,
	PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `user_login_log`(
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `user_no` varchar(50) null,
    `user_pwd` varchar(50) null,
    `ip_addr` varchar(50) null,
    `failure_reason` varchar(50) null,
    `login_status` tinyint default 0 not null,
    `web_referer` varchar(128) null,
    `web_user_agent` varchar(256) null,

    `created` datetime null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `user_department`(
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `user_id` bigint(20) NOT NULL,
    `department_id` bigint(20) NOT NULL,
    `parent_department_ids` varchar(256) NOT NULL,

    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `modify_user_id` bigint null,
    `modify_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX idx_user_dept(user_id, department_id)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_page` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `space_id` bigint(20) NULL DEFAULT NULL,
    `page_id` bigint(20) NULL DEFAULT NULL,
    `page_status` tinyint default 0 not null,
    `char_num` int NULL DEFAULT NULL,
    `segment_num` int NULL DEFAULT NULL,
    `page_name` varchar(256) NULL DEFAULT NULL,
    `page_content` mediumtext null,
    `create_time` datetime NULL DEFAULT NULL,
    `update_time` datetime NULL DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_space_page_id` (space_id, page_id)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_page_segment` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `space_id` bigint(20) NULL DEFAULT NULL,
    `page_id` bigint(20) NULL DEFAULT NULL,
    `segment_hash` int null,
    `segment_content` text null,
    `search_content` text NULL,
    `create_time` datetime NULL DEFAULT NULL,
    `update_time` datetime NULL DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_space_page_id` (space_id, page_id)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_application` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `uuid` varchar(50) NULL DEFAULT NULL,
    `app_name` varchar(50) NULL DEFAULT NULL,
    `app_desc` varchar(256) NULL DEFAULT NULL,
    `prompt_text` varchar(1024) NULL DEFAULT NULL,
    `prologue_text` varchar(1024) NULL DEFAULT NULL,
    `space_ids` varchar(100) NULL DEFAULT NULL,
    `chat_icon` varchar(256) NULL DEFAULT NULL,
    `entrance_icon` varchar(256) NULL DEFAULT NULL,
    `no_ref_answer` varchar(256) NULL DEFAULT NULL,
    `share_status` tinyint default 0 not null,
    `login_required` tinyint default 0 not null,
    `enable_deep_think` tinyint default 0 not null,
    `display_language` varchar(10) NULL DEFAULT NULL,
    `develop_mode` tinyint default 1 not null,
    `flow_content` mediumtext NULL,
    `history_chat_num` int null,
    `user_color` varchar(20) NULL,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `modify_user_id` bigint null,
    `modify_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `idx_uuid`(`uuid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_app_chat` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `app_id` bigint(20) NOT NULL,
    `user_uuid` varchar(50) NULL DEFAULT NULL,
    `chat_uuid` varchar(50) NULL DEFAULT NULL,
    `abstract_title` varchar(128) NULL DEFAULT NULL,
    `chat_num` int default 0 not null,
    `usage_tokens` int default 0 not null,
    `new_user_flag` tinyint default 0 not null,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_app_id` (`app_id`),
    INDEX `idx_user_uuid` (`user_uuid`),
    UNIQUE INDEX `idx_chat_uuid`(`chat_uuid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_app_chat_msg` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `chat_id` bigint(20) NOT NULL,
    `source_pages` varchar(1024) null,
    `use_time` double null,
    `usage_tokens` int null,
    `question` text null,
    `answer` text null,
    `prompt` text null,
    `logic_flow` mediumtext NULL,
    `created` datetime null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_chat_id` (`chat_id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_app_statistic` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `app_id` bigint(20) NOT NULL,
    `user_uuid` varchar(50) NULL DEFAULT NULL,
    `chat_uuid` varchar(50) NULL DEFAULT NULL,
    `chat_num` int default 0 not null,
    `usage_tokens` int default 0 not null,
    `new_user_flag` tinyint default 0 not null,
    `dt` int not null,
    PRIMARY KEY (`id`),
    UNIQUE INDEX idx_space_page_user_dt(app_id, user_uuid, chat_uuid, dt),
    INDEX `idx_app_id` (`app_id`),
    INDEX `idx_user_uuid` (`app_id`, `user_uuid`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_app_function` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `func_name` varchar(50) NULL DEFAULT NULL,
    `func_desc` varchar(100) NULL DEFAULT NULL,
    `visible_rang` tinyint default 0 not null,
    `func_main` varchar(100) NULL DEFAULT NULL,
    `func_code` text NULL DEFAULT NULL,
    `func_params` varchar(1024) NULL DEFAULT NULL,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `modify_user_id` bigint null,
    `modify_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `page_view_log` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `space_id` bigint(20) default null,
    `page_id` bigint(20) not null,
    `created` datetime null,
    `view_source` tinyint default 1 not null,
    `view_user_id` varchar(50) null,
    `view_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_page_id`(`space_id`, `page_id`, `view_user_id`),
    INDEX `idx_user_id` (`view_user_id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `page_action_log` (
    `id` bigint(20) not null auto_increment,
    `space_id` bigint(20) default null,
    `page_id` bigint(20) not null,
    `action_type` tinyint default 0 not null,
    `auth_type` tinyint default 0 not null,
    `target_dept_id` bigint(20) null default null,
    `target_dept_name` varchar(50) null,
    `target_user_id` bigint(20) null default null,
    `target_user_name` varchar(50) null,
    `include_children_dept` tinyint default 0 not null,
    `include_children_page` tinyint default 0 not null,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_page_id`(`page_id`, `action_type`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_space_background` (
    `id` bigint(20) not null auto_increment,
    `tag_name` varchar(50) null,
    `config_type` tinyint default 1 not null,
    `background` varchar(256) null,
    `color_type` tinyint default 1 not null,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `modify_user_id` bigint null,
    `modify_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_webhook_config` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `space_id` bigint null,
    `page_id` bigint null,
    `scope_type` tinyint default 0 not null,
    `creator_type` tinyint default 0 not null,
    `notify_name` varchar(100) NULL DEFAULT NULL,
    `notify_url` varchar(512) NULL DEFAULT NULL,
    `notify_events` varchar(1024) NULL DEFAULT NULL,
    `notify_frequency` int default 0 not null,
    `notify_Source` varchar(50) NULL,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `modify_user_id` bigint null,
    `modify_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_webhook_log` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `webhook_id` bigint null,
    `event_type` varchar(50) NULL DEFAULT NULL,
    `notify_url` varchar(512) NULL DEFAULT NULL,
    `log_content` text NULL,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_inner_chat` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `user_uuid` varchar(50) NULL DEFAULT NULL,
    `chat_uuid` varchar(50) NULL DEFAULT NULL,
    `abstract_title` varchar(128) NULL DEFAULT NULL,
    `chat_num` int default 0 not null,
    `usage_tokens` int default 0 not null,
    `new_user_flag` tinyint default 0 not null,
    `space_uuid` varchar(50) DEFAULT NULL,
    `space_id` bigint null,
    `integrate_uuid` varchar(50) DEFAULT NULL,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_user_uuid` (`user_uuid`),
    INDEX `idx_user_id` (`create_user_id`),
    UNIQUE INDEX `idx_chat_uuid`(`chat_uuid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_inner_chat_msg` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `chat_id` bigint(20) NOT NULL,
    `source_pages` text null,
    `use_time` double null,
    `usage_tokens` int null,
    `question` text null,
    `answer` text null,
    `prompt` text null,
    `created` datetime null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_chat_id` (`chat_id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_inner_statistic` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `user_uuid` varchar(50) NULL DEFAULT NULL,
    `chat_uuid` varchar(50) NULL DEFAULT NULL,
    `chat_num` int default 0 not null,
    `usage_tokens` int default 0 not null,
    `new_user_flag` tinyint default 0 not null,
    `dt` int not null,
    PRIMARY KEY (`id`),
    UNIQUE INDEX idx_user_chat_dt(user_uuid, chat_uuid, dt),
    INDEX `idx_user_uuid` (`user_uuid`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_third_party_config` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `config_name` varchar(100) NULL DEFAULT NULL,
    `config_type` tinyint not null,
    `config_id` bigint null,
    `third_party_type` tinyint not null,
    `app_key` varchar(100) NULL DEFAULT NULL,
    `app_secret` varchar(256) NULL DEFAULT NULL,
    `app_token` varchar(100) NULL DEFAULT NULL,
    `app_aes_key` varchar(100) NULL DEFAULT NULL,
    `corp_id` varchar(100) NULL DEFAULT NULL,
    `card_template_id` varchar(100) NULL DEFAULT NULL,
    `wellcome_msg` varchar(1024) null,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `modify_user_id` bigint null,
    `modify_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_config` (`config_type`, `config_id`),
    UNIQUE INDEX `idx_app_key`(`app_key`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_tags` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `parent_id` bigint(20) NOT NULL DEFAULT 0,
    `tag_type` tinyint not null,
    `tag_name` varchar(20) NULL DEFAULT NULL,
    `tag_color` varchar(20) NULL DEFAULT NULL,
    `tag_icon` varchar(20) NULL DEFAULT NULL,
    `space_id` bigint null,
    `seq_no` int(11) NOT NULL DEFAULT 0,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `modify_user_id` bigint null,
    `modify_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_tag_type` (`tag_type`),
    INDEX `idx_type_space` (`tag_type`, `space_id`),
    INDEX `idx_type_user` (`tag_type`, `create_user_id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `wiki_page_tags` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `tag_id` bigint null,
    `space_id` bigint null,
    `page_id` bigint null,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `idx_tag_page`(`tag_id`, `space_id`, `page_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_third_party_sync` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `space_id` bigint null,
    `name` varchar(20) NULL DEFAULT NULL,
    `sync_type` tinyint not null,
    `api_key` varchar(128) NULL DEFAULT NULL,
    `created` datetime null,
    `create_user_id` bigint null,
    `create_user` varchar(50) null,
    `modified` datetime null,
    `modify_user_id` bigint null,
    `modify_user` varchar(50) null,
    `yn` tinyint default 1 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_space_id` (`space_id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `ai_qywx_kf_msg` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `open_kf_id` varchar(50) NULL,
    `next_cursor` varchar(100) NULL,
    `msg_id` varchar(50) NULL,
    `external_userid` varchar(50) NULL,
    `msg_type` varchar(50) NULL,
    `text_content` varchar(1024) NULL,
    `send_time` datetime null,
    `origin` integer null,
    `servicer_userid` varchar(50) NULL,
    `event_type` varchar(50) NULL,
    `welcome_code` varchar(100) NULL,
    `msg_status` tinyint default 0 not null,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_open_kf_id` (`open_kf_id`)
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- ！！注意！！新加的表时必须加入到备份任务中去

-- -------------------插入必要的数据-------------------
-- 用户信息
INSERT INTO `user_info` (id, user_no, password, user_name, email, del_flag, creation_time, update_time, sex)
VALUES (1, 'admin', 'e10adc3949ba59abbe56e057f20f883e', '系统管理员', 'admin@aibp.work', 0, '2018-12-01 11:37:39', '2018-12-01 11:37:39', 1);
-- 权限列表
INSERT INTO `auth_info` (id, auth_name, auth_desc, can_edit, create_uid, creation_time, auth_type)
VALUES (1, 'SYSTEM_MANAGE', '系统管理权', 0, 1, '2018-12-01 11:37:39', 1),
       (2, 'WIKI_CREATE_SPACE', '空间创建权', 0, 1, '2022-12-10 11:37:39', 1),
       (3, 'INTEGRATE_MANAGE', '文集管理权', 0, 1, '2024-02-29 15:26:17', 1),
       (4, 'AI_APP_MANAGE', 'AI应用管理权', 0, 1, '2024-08-15 15:26:17', 1),
       (5, 'USER_MANAGE', '用户管理权', 0, 1, '2025-05-14 15:26:17', 1);

-- 用户权限
INSERT INTO `user_auth` (id, user_id, auth_id, create_uid, update_uid, del_flag, creation_time)
VALUES (1, 1, 1, 1, 1, 0, '2018-12-01 11:37:39'),
       (2, 1, 2, 1, 1, 0, '2018-12-01 11:37:39'),
       (3, 1, 3, 1, 1, 0, '2018-12-01 11:37:39'),
       (4, 1, 4, 1, 1, 0, '2018-12-01 11:37:39'),
       (5, 1, 5, 1, 1, 0, '2018-12-01 11:37:39');

-- 背景色
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Gradient',3,'#a8edea,#fed6e3',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Gradient',3,'#9795f0,#fbc8d4',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Gradient',3,'#fad0c4,#ffd1ff',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Gradient',3,'#fbc2eb,#a6c1ee',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Gradient',3,'#a6c0fe,#f68084',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Gradient',3,'#e0c3fc,#8ec5fc',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Pure',2,'#CC9999',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Pure',2,'#FF6666',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Pure',2,'#0099CC',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Pure',2,'#CC3399',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Pure',2,'#FF9900',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Pure',2,'#99CC00',1,now(),now(),1);
