-- ------------------------------------------------
-- 全量建表脚本
-- ------------------------------------------------

CREATE TABLE auth_info (
  id BIGINT NOT NULL IDENTITY(1,1),
  auth_name VARCHAR(50),
  auth_desc VARCHAR(100),
  can_edit SMALLINT DEFAULT 1,
  create_uid BIGINT,
  creation_time DATETIME,
  auth_type SMALLINT NOT NULL DEFAULT 0,
  CONSTRAINT pk_auth_info PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_auth_info_auth_name ON auth_info(auth_name);

CREATE TABLE user_auth (
  id BIGINT NOT NULL IDENTITY(1,1),
  user_id BIGINT DEFAULT NULL,
  auth_id BIGINT DEFAULT NULL,
  create_uid BIGINT DEFAULT NULL,
  update_uid BIGINT DEFAULT NULL,
  del_flag NUMBER(4) DEFAULT 0,
  creation_time TIMESTAMP DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  sys_type NUMBER DEFAULT NULL,
  sys_module_type NUMBER DEFAULT NULL,
  sys_module_id BIGINT DEFAULT NULL,
  CONSTRAINT pk_user_auth PRIMARY KEY (id)
);
CREATE INDEX idx_user_auth_user ON user_auth(user_id, del_flag);

CREATE TABLE user_info (
  id BIGINT NOT NULL IDENTITY(1,1),
  user_no VARCHAR(50) DEFAULT NULL,
  password VARCHAR(50) DEFAULT NULL,
  user_name VARCHAR(50) DEFAULT NULL,
  email VARCHAR(50) DEFAULT NULL,
  avatar VARCHAR(256) DEFAULT NULL,
  del_flag NUMBER(4) NOT NULL DEFAULT 0,
  creation_time TIMESTAMP DEFAULT NULL,
  create_uid BIGINT DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  phone VARCHAR(20) DEFAULT NULL,
  sex NUMBER(4) NOT NULL DEFAULT 0,
  department_id BIGINT NOT NULL DEFAULT 0,
  parent_department_ids VARCHAR(100) DEFAULT NULL,
  user_status NUMBER(4) NOT NULL DEFAULT 1,
  verify_code VARCHAR(50) DEFAULT NULL,
  send_code_time TIMESTAMP DEFAULT NULL,
  language VARCHAR(10) DEFAULT NULL,
  user_desc VARCHAR(256) DEFAULT NULL,
  last_login_time TIMESTAMP DEFAULT NULL,
  CONSTRAINT pk_user_info PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_user_info_userNo ON user_info(user_no);

CREATE TABLE wiki_page (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT DEFAULT NULL,
  name VARCHAR(256) DEFAULT NULL,
  parent_id BIGINT NOT NULL DEFAULT 0,
  node_type NUMBER(4) DEFAULT 0,
  zan_num NUMBER(11) NOT NULL DEFAULT 0,
  edit_type NUMBER(4) NOT NULL DEFAULT 0,
  create_user_id BIGINT DEFAULT NULL,
  create_user_name VARCHAR(20) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id BIGINT DEFAULT NULL,
  update_user_name VARCHAR(20) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  del_flag NUMBER(4) NOT NULL DEFAULT 0,
  view_num NUMBER(11) NOT NULL DEFAULT 0,
  seq_no NUMBER(11) NOT NULL DEFAULT 0,
  editor_type NUMBER(4) NOT NULL DEFAULT 1,
  uuid VARCHAR(40) DEFAULT NULL,
  share_flag NUMBER(4) NOT NULL DEFAULT 0,
  share_password VARCHAR(20) DEFAULT NULL,
  share_include_children NUMBER(4) NOT NULL DEFAULT 0,
  share_expiration_date TIMESTAMP DEFAULT NULL,
  file_extension VARCHAR(20) DEFAULT NULL,
  from_page_id BIGINT DEFAULT NULL,
  ai_page_id VARCHAR(50) DEFAULT NULL,
  release_status NUMBER(4) DEFAULT 0,
  quote_page_id BIGINT DEFAULT NULL,
  CONSTRAINT pk_wiki_page PRIMARY KEY (id)
);
CREATE UNIQUE INDEX uni_wiki_page_uuid ON wiki_page(uuid);
CREATE INDEX idx_wiki_page_space_id ON wiki_page(space_id);
CREATE INDEX idx_wiki_page_quote_page_id ON wiki_page(quote_page_id);

CREATE TABLE wiki_page_comment (
  id BIGINT NOT NULL IDENTITY(1,1),
  page_id BIGINT DEFAULT NULL,
  parent_id BIGINT DEFAULT NULL,
  content CLOB DEFAULT NULL,
  zan_num NUMBER(11) NOT NULL DEFAULT 0,
  create_user_id BIGINT DEFAULT NULL,
  create_user_name VARCHAR(20) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  del_flag NUMBER(4) DEFAULT 0,
  CONSTRAINT pk_wiki_page_comment PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_page_comment_page_id ON wiki_page_comment(page_id);

CREATE TABLE wiki_page_content (
  id BIGINT NOT NULL IDENTITY(1,1),
  page_id BIGINT DEFAULT NULL,
  content CLOB DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user_name VARCHAR(20) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id BIGINT DEFAULT NULL,
  update_user_name VARCHAR(20) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  preview CLOB DEFAULT NULL,
  space_id BIGINT DEFAULT NULL,
  edit_content CLOB DEFAULT NULL,
  search_content CLOB DEFAULT NULL,
  CONSTRAINT pk_wiki_page_content PRIMARY KEY (id)
);
CREATE UNIQUE INDEX uk_wiki_page_content_page_id ON wiki_page_content(page_id);

CREATE TABLE wiki_page_file (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT DEFAULT NULL,
  page_id BIGINT DEFAULT NULL,
  file_name VARCHAR(256) DEFAULT NULL,
  file_url VARCHAR(512) DEFAULT NULL,
  uuid VARCHAR(40) DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user_name VARCHAR(20) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id BIGINT DEFAULT NULL,
  update_user_name VARCHAR(20) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  del_flag NUMBER(4) DEFAULT 0,
  download_num NUMBER(11) NOT NULL DEFAULT 0,
  file_size BIGINT DEFAULT NULL,
  file_source NUMBER(4) NOT NULL DEFAULT 1,
  storage_type NUMBER(4) NOT NULL DEFAULT 1,
  integrate_id BIGINT DEFAULT NULL,
  object_path VARCHAR(512) DEFAULT NULL,
  data_id BIGINT DEFAULT NULL,
  file_origin NUMBER DEFAULT NULL,
  CONSTRAINT pk_wiki_page_file PRIMARY KEY (id)
);
CREATE UNIQUE INDEX uk_wiki_page_file_uuid ON wiki_page_file(uuid);
CREATE INDEX idx_wiki_page_file_space_page ON wiki_page_file(space_id, page_id, del_flag);

CREATE TABLE wiki_page_history (
  id BIGINT NOT NULL IDENTITY(1,1),
  page_id BIGINT DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user_name VARCHAR(20) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  del_flag NUMBER(4) NOT NULL DEFAULT 0,
  name VARCHAR(256) DEFAULT NULL,
  content BLOB DEFAULT NULL,
  preview BLOB DEFAULT NULL,
  description VARCHAR(256) DEFAULT NULL,
  CONSTRAINT pk_wiki_page_history PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_page_history_page_id ON wiki_page_history(page_id);

CREATE TABLE wiki_page_zan (
  id BIGINT NOT NULL IDENTITY(1,1),
  page_id BIGINT DEFAULT NULL,
  comment_id BIGINT DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user_name VARCHAR(20) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  yn NUMBER(4) DEFAULT NULL,
  CONSTRAINT pk_wiki_page_zan PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_page_zan_page ON wiki_page_zan(page_id, yn);

CREATE TABLE wiki_space (
  id BIGINT NOT NULL IDENTITY(1,1),
  name VARCHAR(50) DEFAULT NULL,
  type NUMBER(4) DEFAULT 1,
  uuid VARCHAR(40) DEFAULT NULL,
  space_explain VARCHAR(255) DEFAULT NULL,
  logo_url VARCHAR(512) DEFAULT NULL,
  cover_url VARCHAR(512) DEFAULT NULL,
  edit_type NUMBER(4) NOT NULL DEFAULT 0,
  tree_lazy_load NUMBER(4) NOT NULL DEFAULT 0,
  open_doc NUMBER(4) NOT NULL DEFAULT 0,
  annex_open_type NUMBER(4) NOT NULL DEFAULT 1,
  statistics_key VARCHAR(50) DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user_name VARCHAR(20) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  del_flag NUMBER(4) NOT NULL DEFAULT 0,
  group_id BIGINT NOT NULL DEFAULT 0,
  seq_no NUMBER NOT NULL DEFAULT 999,
  share_enable_password NUMBER(4) NOT NULL DEFAULT 0,
  share_password VARCHAR(20) DEFAULT NULL,
  share_password_tips CLOB DEFAULT NULL,
  share_enable_probation NUMBER(4) NOT NULL DEFAULT 0,
  share_probation_ids VARCHAR(1024) DEFAULT NULL,
  share_enable_payment NUMBER(4) NOT NULL DEFAULT 0,
  share_price BIGINT DEFAULT NULL,
  share_single_visit NUMBER(4) NOT NULL DEFAULT 0,
  share_allow_use_num NUMBER NOT NULL DEFAULT 0,
  share_expiry_day NUMBER NOT NULL DEFAULT 0,
  version_control NUMBER(4) NOT NULL DEFAULT 0,
  viewer_allowed_export NUMBER(4) NOT NULL DEFAULT 2,
  share_display CLOB DEFAULT NULL,
  copy_control NUMBER(4) NOT NULL DEFAULT 0,
  copy_control_line NUMBER DEFAULT NULL,
  global_variables CLOB DEFAULT NULL,
  ai_kb_id VARCHAR(50) DEFAULT NULL,
  ai_sync_enable NUMBER(4) NOT NULL DEFAULT 0,
  cover_color_type NUMBER(4) DEFAULT NULL,
  release_control NUMBER(4) DEFAULT 0,
  new_page_position NUMBER(4) DEFAULT 1,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  CONSTRAINT pk_wiki_space PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_wiki_space_uuid ON wiki_space(uuid);

CREATE TABLE user_message (
  id BIGINT NOT NULL IDENTITY(1,1),
  sys_type NUMBER(4) NOT NULL DEFAULT 1,
  msg_type NUMBER NOT NULL DEFAULT 1,
  data_id BIGINT DEFAULT NULL,
  data_desc VARCHAR(100) DEFAULT NULL,
  msg_content VARCHAR(255) DEFAULT NULL,
  msg_status NUMBER(4) NOT NULL DEFAULT 0,
  operator_user_id BIGINT DEFAULT NULL,
  operator_user_name VARCHAR(20) DEFAULT NULL,
  affect_user_id BIGINT DEFAULT NULL,
  affect_user_name VARCHAR(20) DEFAULT NULL,
  accept_user_id BIGINT DEFAULT NULL,
  creation_time TIMESTAMP DEFAULT NULL,
  CONSTRAINT pk_user_message PRIMARY KEY (id)
);
CREATE INDEX idx_user_message_affect_user_id ON user_message(affect_user_id, msg_status);

CREATE TABLE wiki_space_favorite (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT DEFAULT NULL,
  user_id BIGINT DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  del_flag NUMBER(4) NOT NULL DEFAULT 0,
  CONSTRAINT pk_wiki_space_favorite PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_space_favorite_user_id ON wiki_space_favorite(user_id, del_flag);

CREATE TABLE user_setting (
  id BIGINT NOT NULL IDENTITY(1,1),
  user_id BIGINT DEFAULT NULL,
  name VARCHAR(100) DEFAULT NULL,
  value CLOB DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  del_flag NUMBER(4) NOT NULL DEFAULT 0,
  CONSTRAINT pk_user_setting PRIMARY KEY (id)
);
CREATE INDEX idx_user_setting_user_id ON user_setting(user_id, del_flag);

CREATE TABLE wiki_page_favorite (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT DEFAULT NULL,
  page_id BIGINT DEFAULT NULL,
  user_id BIGINT DEFAULT NULL,
  favorite NUMBER(4) NOT NULL DEFAULT 0,
  create_time TIMESTAMP DEFAULT NULL,
  CONSTRAINT pk_wiki_page_favorite PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_page_favorite_user_id ON wiki_page_favorite(user_id, space_id, favorite);

CREATE TABLE user_data_auth (
  id BIGINT NOT NULL IDENTITY(1,1),
  user_id BIGINT DEFAULT NULL,
  department_id BIGINT DEFAULT NULL,
  sys_type NUMBER DEFAULT NULL,
  sys_module_type NUMBER DEFAULT NULL,
  sys_module_id BIGINT DEFAULT NULL,
  include_children NUMBER(4) NOT NULL DEFAULT 0,
  include_children_page NUMBER(4) NOT NULL DEFAULT 0,
  space_id BIGINT DEFAULT NULL,
  expiration_time TIMESTAMP DEFAULT NULL,
  create_uid BIGINT DEFAULT NULL,
  update_uid BIGINT DEFAULT NULL,
  creation_time TIMESTAMP DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  del_flag NUMBER(4) DEFAULT 0,
  CONSTRAINT pk_user_data_auth PRIMARY KEY (id)
);
CREATE INDEX idx_user_data_auth_sys_module ON user_data_auth(user_id, sys_type, sys_module_type, sys_module_id);
CREATE INDEX idx_user_data_auth_user ON user_data_auth(user_id, del_flag);
CREATE INDEX idx_user_data_auth_dept ON user_data_auth(department_id, del_flag);
CREATE INDEX idx_user_data_auth_space ON user_data_auth(space_id, del_flag);

CREATE TABLE department (
  id BIGINT NOT NULL IDENTITY(1,1),
  parent_id BIGINT DEFAULT NULL,
  external_id VARCHAR(50) DEFAULT NULL,
  department_name VARCHAR(50) DEFAULT NULL,
  department_desc VARCHAR(100) DEFAULT NULL,
  seq_no NUMBER DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user_name VARCHAR(20) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  yn NUMBER(4) DEFAULT NULL,
  CONSTRAINT pk_department PRIMARY KEY (id)
);
CREATE INDEX idx_department_parent_id ON department(parent_id);

CREATE TABLE wiki_page_template (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT DEFAULT NULL,
  page_id BIGINT DEFAULT NULL,
  tag_name VARCHAR(50) DEFAULT NULL,
  share_status NUMBER(4) NOT NULL DEFAULT 0,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_page_template PRIMARY KEY (id)
);

CREATE TABLE system_config (
  id BIGINT NOT NULL IDENTITY(1,1),
  config_key VARCHAR(100) DEFAULT NULL,
  config_value CLOB DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_system_config PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_system_config_config_key ON system_config(config_key);

CREATE TABLE wiki_statistics_action_flow (
  id BIGINT NOT NULL IDENTITY(1,1),
  user_id BIGINT NOT NULL,
  space_id BIGINT NOT NULL,
  page_id BIGINT NOT NULL,
  create_page_num NUMBER NOT NULL DEFAULT 0,
  update_page_num NUMBER NOT NULL DEFAULT 0,
  visit_count NUMBER NOT NULL DEFAULT 0,
  zan_num NUMBER NOT NULL DEFAULT 0,
  favorite_num NUMBER NOT NULL DEFAULT 0,
  comment_num NUMBER NOT NULL DEFAULT 0,
  dt NUMBER NOT NULL,
  CONSTRAINT pk_wiki_statistics_action_flow PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_wiki_statistics_action_flow_space_page_user_dt ON wiki_statistics_action_flow(user_id, space_id, page_id, dt);
CREATE INDEX idx_wiki_statistics_action_flow_dt ON wiki_statistics_action_flow(dt);

CREATE TABLE wiki_statistics_total_dt (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT NOT NULL,
  total_page_num NUMBER NOT NULL DEFAULT 0,
  create_page_num NUMBER NOT NULL DEFAULT 0,
  update_page_num NUMBER NOT NULL DEFAULT 0,
  visit_user_num NUMBER NOT NULL DEFAULT 0,
  visit_count NUMBER NOT NULL DEFAULT 0,
  comment_num NUMBER NOT NULL DEFAULT 0,
  zan_num NUMBER NOT NULL DEFAULT 0,
  favorite_num NUMBER NOT NULL DEFAULT 0,
  dt NUMBER NOT NULL,
  show_dt VARCHAR(30) NOT NULL,
  CONSTRAINT pk_wiki_statistics_total_dt PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_wiki_statistics_total_dt_space_dt ON wiki_statistics_total_dt(space_id, dt);
CREATE INDEX idx_wiki_statistics_total_dt_statistics_total_dt_dt ON wiki_statistics_total_dt(dt);

CREATE TABLE wiki_statistics_page_dt (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT NOT NULL,
  page_id BIGINT NOT NULL,
  page_name VARCHAR(256) NOT NULL,
  visit_user_num NUMBER NOT NULL DEFAULT 0,
  visit_count NUMBER NOT NULL DEFAULT 0,
  comment_num NUMBER NOT NULL DEFAULT 0,
  zan_num NUMBER NOT NULL DEFAULT 0,
  favorite_num NUMBER NOT NULL DEFAULT 0,
  dt NUMBER NOT NULL,
  show_dt VARCHAR(30) NOT NULL,
  CONSTRAINT pk_wiki_statistics_page_dt PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_wiki_statistics_page_dt_space_page_dt ON wiki_statistics_page_dt(space_id, page_id, dt);
CREATE INDEX idx_wiki_statistics_page_dt_dt ON wiki_statistics_page_dt(dt);
CREATE INDEX idx_wiki_statistics_page_dt_space_dt ON wiki_statistics_page_dt(space_id, dt);

CREATE TABLE wiki_statistics_user_dt (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT NOT NULL,
  user_id BIGINT NOT NULL,
  user_name VARCHAR(50) NOT NULL,
  create_page_num NUMBER NOT NULL DEFAULT 0,
  update_page_num NUMBER NOT NULL DEFAULT 0,
  visit_page_num NUMBER NOT NULL DEFAULT 0,
  visit_count NUMBER NOT NULL DEFAULT 0,
  zan_num NUMBER NOT NULL DEFAULT 0,
  favorite_num NUMBER NOT NULL DEFAULT 0,
  comment_num NUMBER NOT NULL DEFAULT 0,
  received_visit_page_num NUMBER NOT NULL DEFAULT 0,
  received_visit_count NUMBER NOT NULL DEFAULT 0,
  received_zan_num NUMBER NOT NULL DEFAULT 0,
  received_favorite_num NUMBER NOT NULL DEFAULT 0,
  received_comment_num NUMBER NOT NULL DEFAULT 0,
  dt NUMBER NOT NULL,
  show_dt VARCHAR(30) NOT NULL,
  CONSTRAINT pk_wiki_statistics_user_dt PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_wiki_statistics_user_dt_space_user_dt ON wiki_statistics_user_dt(space_id, user_id, dt);
CREATE INDEX idx_wiki_statistics_user_dt_dt ON wiki_statistics_user_dt(dt);
CREATE INDEX idx_wiki_statistics_user_dt_space_dt ON wiki_statistics_user_dt(space_id, dt);

CREATE TABLE wiki_share_comment (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT DEFAULT NULL,
  page_id BIGINT DEFAULT NULL,
  select_text VARCHAR(1024) DEFAULT NULL,
  comment_url VARCHAR(256) DEFAULT NULL,
  integrate_uuid VARCHAR(50) DEFAULT NULL,
  feedback_type NUMBER(4) NOT NULL DEFAULT 1,
  comment_text VARCHAR(500) DEFAULT NULL,
  process_status NUMBER(4) NOT NULL DEFAULT 0,
  created TIMESTAMP DEFAULT NULL,
  CONSTRAINT pk_wiki_share_comment PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_share_comment_space_id ON wiki_share_comment(space_id);

CREATE TABLE wiki_integrate (
  id BIGINT NOT NULL IDENTITY(1,1),
  integrate_status NUMBER(4) NOT NULL DEFAULT 1,
  integrate_name VARCHAR(50) DEFAULT NULL,
  integrate_desc VARCHAR(100) DEFAULT NULL,
  uuid VARCHAR(100) DEFAULT NULL,
  space_uuid VARCHAR(1024) DEFAULT NULL,
  charge_user_id BIGINT DEFAULT NULL,
  charge_user_name VARCHAR(20) DEFAULT NULL,
  logo_url VARCHAR(512) DEFAULT NULL,
  integrate_title VARCHAR(50) DEFAULT NULL,
  home_page_content CLOB DEFAULT NULL,
  menu_content CLOB DEFAULT NULL,
  statistics_key VARCHAR(50) DEFAULT NULL,
  show_home_page NUMBER(4) NOT NULL DEFAULT 0,
  share_enable_password NUMBER(4) NOT NULL DEFAULT 0,
  share_password VARCHAR(20) DEFAULT NULL,
  share_password_tips CLOB DEFAULT NULL,
  share_enable_probation NUMBER(4) NOT NULL DEFAULT 0,
  share_enable_payment NUMBER(4) NOT NULL DEFAULT 0,
  share_price BIGINT DEFAULT NULL,
  share_single_visit NUMBER(4) NOT NULL DEFAULT 0,
  share_allow_use_num NUMBER NOT NULL DEFAULT 0,
  share_expiry_day NUMBER NOT NULL DEFAULT 0,
  version_control NUMBER(4) NOT NULL DEFAULT 0,
  ad_enable NUMBER(4) NOT NULL DEFAULT 0,
  ad_list CLOB DEFAULT NULL,
  display_setting CLOB DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_integrate PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_wiki_integrate_uuid ON wiki_integrate(uuid);

CREATE TABLE wiki_domain_mapping (
  id BIGINT NOT NULL IDENTITY(1,1),
  visit_domain VARCHAR(50) DEFAULT NULL,
  mapping_type NUMBER(4) NOT NULL DEFAULT 1,
  mapping_id BIGINT DEFAULT NULL,
  mapping_uuid VARCHAR(40) DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_domain_mapping PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_wiki_domain_mapping_visit_domain ON wiki_domain_mapping(visit_domain);

CREATE TABLE wiki_space_group (
  id BIGINT NOT NULL IDENTITY(1,1),
  group_name VARCHAR(100) DEFAULT NULL,
  seq_no NUMBER NOT NULL DEFAULT 999,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_space_group PRIMARY KEY (id)
);

CREATE TABLE wiki_custom_component (
  id BIGINT NOT NULL IDENTITY(1,1),
  component_code VARCHAR(50) DEFAULT NULL,
  component_name VARCHAR(50) DEFAULT NULL,
  component_desc VARCHAR(256) DEFAULT NULL,
  component_content CLOB DEFAULT NULL,
  component_status NUMBER(4) NOT NULL DEFAULT 1,
  template_code VARCHAR(512) DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_custom_component PRIMARY KEY (id)
);

CREATE TABLE wiki_dynamic_password (
  id BIGINT NOT NULL IDENTITY(1,1),
  source_id BIGINT NOT NULL,
  source_type NUMBER(4) NOT NULL,
  password_desc VARCHAR(256) DEFAULT NULL,
  share_password VARCHAR(50) DEFAULT NULL,
  single_visit NUMBER(4) NOT NULL DEFAULT 0,
  allow_use_num NUMBER NOT NULL DEFAULT 0,
  used_num NUMBER NOT NULL DEFAULT 0,
  expiry_day NUMBER NOT NULL DEFAULT 0,
  source_from NUMBER(4) NOT NULL DEFAULT 1,
  order_no VARCHAR(50) DEFAULT NULL,
  order_status NUMBER(4) NOT NULL DEFAULT 1,
  ware_name VARCHAR(100) DEFAULT NULL,
  ware_price BIGINT DEFAULT NULL,
  ware_password VARCHAR(500) DEFAULT NULL,
  ware_payment_info VARCHAR(1024) DEFAULT NULL,
  visit_ip VARCHAR(50) DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_dynamic_password PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_dynamic_password_source_id ON wiki_dynamic_password(source_id, source_type);

CREATE TABLE wiki_dynamic_password_visit (
  id BIGINT NOT NULL IDENTITY(1,1),
  dynamic_password_id BIGINT NOT NULL,
  visit_ip VARCHAR(50) DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  CONSTRAINT pk_wiki_dynamic_password_visit PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_dynamic_password_visit_dynamic_password_id ON wiki_dynamic_password_visit(dynamic_password_id);

CREATE TABLE wiki_version_control (
  id BIGINT NOT NULL IDENTITY(1,1),
  source_id BIGINT NOT NULL,
  source_type NUMBER(4) NOT NULL,
  version_name VARCHAR(20) DEFAULT NULL,
  logo_url VARCHAR(512) DEFAULT NULL,
  integrate_title VARCHAR(50) DEFAULT NULL,
  home_page_content CLOB DEFAULT NULL,
  menu_content CLOB DEFAULT NULL,
  statistics_key VARCHAR(50) DEFAULT NULL,
  show_home_page NUMBER(4) NOT NULL DEFAULT 0,
  space_uuid VARCHAR(1024) DEFAULT NULL,
  target_version_id BIGINT DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_version_control PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_version_control_source_id ON wiki_version_control(source_id, source_type);

CREATE TABLE wiki_page_version (
  id BIGINT NOT NULL IDENTITY(1,1),
  version_id BIGINT DEFAULT NULL,
  page_id BIGINT DEFAULT NULL,
  space_id BIGINT DEFAULT NULL,
  parent_id BIGINT NOT NULL DEFAULT 0,
  name VARCHAR(256) DEFAULT NULL,
  seq_no NUMBER NOT NULL DEFAULT 0,
  editor_type NUMBER(4) NOT NULL DEFAULT 1,
  content CLOB DEFAULT NULL,
  preview CLOB DEFAULT NULL,
  search_content CLOB DEFAULT NULL,
  file_extension VARCHAR(20) DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_page_version PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_page_version_version_space ON wiki_page_version(version_id, space_id);

CREATE TABLE wiki_api_environment (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT NOT NULL,
  environment_name VARCHAR(20) DEFAULT NULL,
  seq_no NUMBER NOT NULL DEFAULT 0,
  share_env NUMBER(4) NOT NULL DEFAULT 0,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_api_environment PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_api_environment_source_id ON wiki_api_environment(space_id);

CREATE TABLE wiki_api_service (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT NOT NULL,
  service_name VARCHAR(50) DEFAULT NULL,
  seq_no NUMBER NOT NULL DEFAULT 0,
  system_flag NUMBER NOT NULL DEFAULT 0,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_api_service PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_api_service_source_id ON wiki_api_service(space_id);

CREATE TABLE wiki_api_env_service (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT NOT NULL,
  service_id BIGINT NOT NULL,
  environment_id BIGINT NOT NULL,
  service_url VARCHAR(100) DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_api_env_service PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_api_env_service_source_id ON wiki_api_env_service(space_id);

CREATE TABLE ai_answer_record (
  id BIGINT NOT NULL IDENTITY(1,1),
  question CLOB DEFAULT NULL,
  answer CLOB DEFAULT NULL,
  source_pages VARCHAR(1024) DEFAULT NULL,
  space_id BIGINT DEFAULT NULL,
  space_uuid VARCHAR(40) DEFAULT NULL,
  integrate_uuid VARCHAR(40) DEFAULT NULL,
  question_from NUMBER(4) NOT NULL DEFAULT 0,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_ai_answer_record PRIMARY KEY (id)
);

CREATE TABLE user_login_log (
  id BIGINT NOT NULL IDENTITY(1,1),
  user_no VARCHAR(50) DEFAULT NULL,
  user_pwd VARCHAR(50) DEFAULT NULL,
  ip_addr VARCHAR(50) DEFAULT NULL,
  failure_reason VARCHAR(50) DEFAULT NULL,
  login_status NUMBER(4) NOT NULL DEFAULT 0,
  web_referer VARCHAR(128) DEFAULT NULL,
  web_user_agent VARCHAR(256) DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_user_login_log PRIMARY KEY (id)
);

CREATE TABLE user_department (
  id BIGINT NOT NULL IDENTITY(1,1),
  user_id BIGINT NOT NULL,
  department_id BIGINT NOT NULL,
  parent_department_ids VARCHAR(256) NOT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_user_department PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_user_department_user_dept ON user_department(user_id, department_id);

CREATE TABLE ai_page (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT DEFAULT NULL,
  page_id BIGINT DEFAULT NULL,
  page_status NUMBER(4) NOT NULL DEFAULT 0,
  char_num NUMBER DEFAULT NULL,
  segment_num NUMBER DEFAULT NULL,
  page_name VARCHAR(256) DEFAULT NULL,
  page_content CLOB DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  CONSTRAINT pk_ai_page PRIMARY KEY (id)
);
CREATE INDEX idx_ai_page_space_page_id ON ai_page(space_id, page_id);

CREATE TABLE ai_page_segment (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT DEFAULT NULL,
  page_id BIGINT DEFAULT NULL,
  segment_hash NUMBER DEFAULT NULL,
  segment_content CLOB DEFAULT NULL,
  search_content CLOB DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  CONSTRAINT pk_ai_page_segment PRIMARY KEY (id)
);
CREATE INDEX idx_ai_page_segment_space_page_id ON ai_page_segment(space_id, page_id);

CREATE TABLE ai_application (
  id BIGINT NOT NULL IDENTITY(1,1),
  uuid VARCHAR(50) DEFAULT NULL,
  app_name VARCHAR(50) DEFAULT NULL,
  app_desc VARCHAR(256) DEFAULT NULL,
  prompt_text VARCHAR(1024) DEFAULT NULL,
  prologue_text VARCHAR(1024) DEFAULT NULL,
  space_ids VARCHAR(100) DEFAULT NULL,
  chat_icon VARCHAR(256) DEFAULT NULL,
  entrance_icon VARCHAR(256) DEFAULT NULL,
  no_ref_answer VARCHAR(256) DEFAULT NULL,
  share_status NUMBER(4) NOT NULL DEFAULT 0,
  login_required NUMBER(4) NOT NULL DEFAULT 0,
  enable_deep_think NUMBER(4) NOT NULL DEFAULT 0,
  display_language VARCHAR(10) DEFAULT NULL,
  develop_mode NUMBER(4) NOT NULL DEFAULT 1,
  flow_content CLOB DEFAULT NULL,
  history_chat_num NUMBER DEFAULT NULL,
  user_color VARCHAR(20) DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_ai_application PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_ai_application_uuid ON ai_application(uuid);

CREATE TABLE ai_app_chat (
  id BIGINT NOT NULL IDENTITY(1,1),
  app_id BIGINT NOT NULL,
  user_uuid VARCHAR(50) DEFAULT NULL,
  chat_uuid VARCHAR(50) DEFAULT NULL,
  abstract_title VARCHAR(128) DEFAULT NULL,
  chat_num NUMBER NOT NULL DEFAULT 0,
  usage_tokens NUMBER NOT NULL DEFAULT 0,
  new_user_flag NUMBER NOT NULL DEFAULT 0,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_ai_app_chat PRIMARY KEY (id)
);
CREATE INDEX idx_ai_app_chat_app_id ON ai_app_chat(app_id);
CREATE INDEX idx_ai_app_chat_user_uuid ON ai_app_chat(user_uuid);
CREATE UNIQUE INDEX idx_ai_app_chat_chat_uuid ON ai_app_chat(chat_uuid);

CREATE TABLE ai_app_chat_msg (
  id BIGINT NOT NULL IDENTITY(1,1),
  chat_id BIGINT NOT NULL,
  source_pages VARCHAR(1024) DEFAULT NULL,
  use_time FLOAT DEFAULT NULL,
  usage_tokens NUMBER DEFAULT NULL,
  question CLOB DEFAULT NULL,
  answer CLOB DEFAULT NULL,
  prompt CLOB DEFAULT NULL,
  logic_flow CLOB DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_ai_app_chat_msg PRIMARY KEY (id)
);
CREATE INDEX idx_ai_app_chat_msg_chat_id ON ai_app_chat_msg(chat_id);

CREATE TABLE ai_app_statistic (
  id BIGINT NOT NULL IDENTITY(1,1),
  app_id BIGINT NOT NULL,
  user_uuid VARCHAR(50) DEFAULT NULL,
  chat_uuid VARCHAR(50) DEFAULT NULL,
  chat_num NUMBER NOT NULL DEFAULT 0,
  usage_tokens NUMBER NOT NULL DEFAULT 0,
  new_user_flag NUMBER NOT NULL DEFAULT 0,
  dt NUMBER NOT NULL,
  CONSTRAINT pk_ai_app_statistic PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_ai_app_statistic_space_page_user_dt ON ai_app_statistic(app_id, user_uuid, chat_uuid, dt);
CREATE INDEX idx_ai_app_statistic_app_id ON ai_app_statistic(app_id);
CREATE INDEX idx_ai_app_statistic_user_uuid ON ai_app_statistic(app_id, user_uuid);

CREATE TABLE ai_app_function (
  id BIGINT NOT NULL IDENTITY(1,1),
  func_name VARCHAR(50) DEFAULT NULL,
  func_desc VARCHAR(100) DEFAULT NULL,
  visible_rang NUMBER(4) NOT NULL DEFAULT 0,
  func_main VARCHAR(100) DEFAULT NULL,
  func_code CLOB DEFAULT NULL,
  func_params VARCHAR(1024) DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_ai_app_function PRIMARY KEY (id)
);

CREATE TABLE page_view_log (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT DEFAULT NULL,
  page_id BIGINT NOT NULL,
  created TIMESTAMP DEFAULT NULL,
  view_source NUMBER(4) NOT NULL DEFAULT 1,
  view_user_id VARCHAR(50) DEFAULT NULL,
  view_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_page_view_log PRIMARY KEY (id)
);
CREATE INDEX idx_page_view_log_page_id ON page_view_log(space_id, page_id, view_user_id);
CREATE INDEX idx_page_view_log_user_id ON page_view_log(view_user_id);

CREATE TABLE page_action_log (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT DEFAULT NULL,
  page_id BIGINT NOT NULL,
  action_type NUMBER(4) NOT NULL DEFAULT 0,
  auth_type NUMBER(4) NOT NULL DEFAULT 0,
  target_dept_id BIGINT DEFAULT NULL,
  target_dept_name VARCHAR(50) DEFAULT NULL,
  target_user_id BIGINT DEFAULT NULL,
  target_user_name VARCHAR(50) DEFAULT NULL,
  include_children_dept NUMBER(4) NOT NULL DEFAULT 0,
  include_children_page NUMBER(4) NOT NULL DEFAULT 0,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_page_action_log PRIMARY KEY (id)
);
CREATE INDEX idx_page_action_log_page_id ON page_action_log(page_id, action_type);

CREATE TABLE wiki_space_background (
  id BIGINT NOT NULL IDENTITY(1,1),
  tag_name VARCHAR(50) DEFAULT NULL,
  config_type NUMBER(4) NOT NULL DEFAULT 1,
  background VARCHAR(256) DEFAULT NULL,
  color_type NUMBER(4) NOT NULL DEFAULT 1,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_space_background PRIMARY KEY (id)
);

CREATE TABLE wiki_webhook_config (
  id BIGINT NOT NULL IDENTITY(1,1),
  space_id BIGINT DEFAULT NULL,
  page_id BIGINT DEFAULT NULL,
  scope_type NUMBER(4) NOT NULL DEFAULT 0,
  creator_type NUMBER(4) NOT NULL DEFAULT 0,
  notify_name VARCHAR(100) DEFAULT NULL,
  notify_url VARCHAR(512) DEFAULT NULL,
  notify_events VARCHAR(1024) DEFAULT NULL,
  notify_frequency NUMBER NOT NULL DEFAULT 0,
  notify_source VARCHAR(50) DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  modify_user_id BIGINT DEFAULT NULL,
  modify_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_webhook_config PRIMARY KEY (id)
);

CREATE TABLE wiki_webhook_log (
  id BIGINT NOT NULL IDENTITY(1,1),
  webhook_id BIGINT DEFAULT NULL,
  event_type VARCHAR(50) DEFAULT NULL,
  notify_url VARCHAR(512) DEFAULT NULL,
  log_content CLOB DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_wiki_webhook_log PRIMARY KEY (id)
);

CREATE TABLE ai_inner_chat (
  id BIGINT NOT NULL IDENTITY(1,1),
  user_uuid VARCHAR(50) DEFAULT NULL,
  chat_uuid VARCHAR(50) DEFAULT NULL,
  abstract_title VARCHAR(128) DEFAULT NULL,
  chat_num NUMBER NOT NULL DEFAULT 0,
  usage_tokens NUMBER NOT NULL DEFAULT 0,
  new_user_flag NUMBER NOT NULL DEFAULT 0,
  space_uuid VARCHAR(50) DEFAULT NULL,
  space_id BIGINT DEFAULT NULL,
  integrate_uuid VARCHAR(50) DEFAULT NULL,
  created TIMESTAMP DEFAULT NULL,
  create_user_id BIGINT DEFAULT NULL,
  create_user VARCHAR(50) DEFAULT NULL,
  modified TIMESTAMP DEFAULT NULL,
  yn NUMBER(4) NOT NULL DEFAULT 1,
  CONSTRAINT pk_ai_inner_chat PRIMARY KEY (id)
);
CREATE INDEX idx_ai_inner_chat_user_uuid ON ai_inner_chat(user_uuid);
CREATE INDEX idx_ai_inner_chat_user_id ON ai_inner_chat(create_user_id);
CREATE UNIQUE INDEX idx_ai_inner_chat_chat_uuid ON ai_inner_chat(chat_uuid);

CREATE TABLE ai_inner_chat_msg (
    id BIGINT NOT NULL IDENTITY(1,1),
    chat_id BIGINT NOT NULL,
    source_pages CLOB NULL,
    use_time DOUBLE PRECISION NULL,
    usage_tokens INT NULL,
    question CLOB NULL,
    answer CLOB NULL,
    prompt CLOB NULL,
    created TIMESTAMP NULL,
    yn NUMBER(1) DEFAULT 1 NOT NULL,
    CONSTRAINT pk_ai_inner_chat_msg PRIMARY KEY (id)
);
CREATE INDEX idx_ai_inner_chat_msg_chat_id ON ai_inner_chat_msg(chat_id);

CREATE TABLE ai_inner_statistic (
    id BIGINT NOT NULL IDENTITY(1,1),
    user_uuid VARCHAR2(50 CHAR) NULL,
    chat_uuid VARCHAR2(50 CHAR) NULL,
    chat_num INT DEFAULT 0 NOT NULL,
    usage_tokens INT DEFAULT 0 NOT NULL,
    new_user_flag NUMBER(1) DEFAULT 0 NOT NULL,
    dt INT NOT NULL,
    CONSTRAINT pk_ai_inner_statistic PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_ai_inner_statistic_user_chat_dt ON ai_inner_statistic(user_uuid, chat_uuid, dt);
CREATE INDEX idx_ai_inner_statistic_user_uuid ON ai_inner_statistic(user_uuid);

CREATE TABLE ai_third_party_config (
    id BIGINT NOT NULL IDENTITY(1,1),
    config_name VARCHAR2(100 CHAR) NULL,
    config_type NUMBER(3) NOT NULL,
    config_id BIGINT NULL,
    third_party_type NUMBER(3) NOT NULL,
    app_key VARCHAR2(100 CHAR) NULL,
    app_secret VARCHAR2(256 CHAR) NULL,
    app_token VARCHAR2(100 CHAR) NULL,
    app_aes_key VARCHAR2(100 CHAR) NULL,
    corp_id VARCHAR2(100 CHAR) NULL,
    card_template_id VARCHAR2(100 CHAR) NULL,
    wellcome_msg VARCHAR2(1024 CHAR) NULL,
    created TIMESTAMP NULL,
    create_user_id BIGINT NULL,
    create_user VARCHAR2(50 CHAR) NULL,
    modified TIMESTAMP NULL,
    modify_user_id BIGINT NULL,
    modify_user VARCHAR2(50 CHAR) NULL,
    yn NUMBER(1) DEFAULT 1 NOT NULL,
    CONSTRAINT pk_ai_third_party_config PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_ai_third_party_config_app_key ON ai_third_party_config(app_key);
CREATE INDEX idx_ai_third_party_config_config ON ai_third_party_config(config_type, config_id);

CREATE TABLE wiki_tags (
    id BIGINT NOT NULL IDENTITY(1,1),
    parent_id BIGINT DEFAULT 0 NOT NULL,
    tag_type NUMBER(3) NOT NULL,
    tag_name VARCHAR2(20 CHAR) NULL,
    tag_color VARCHAR2(20 CHAR) NULL,
    tag_icon VARCHAR2(20 CHAR) NULL,
    space_id BIGINT NULL,
    seq_no INT DEFAULT 0 NOT NULL,
    created TIMESTAMP NULL,
    create_user_id BIGINT NULL,
    create_user VARCHAR2(50 CHAR) NULL,
    modified TIMESTAMP NULL,
    modify_user_id BIGINT NULL,
    modify_user VARCHAR2(50 CHAR) NULL,
    yn NUMBER(1) DEFAULT 1 NOT NULL,
    CONSTRAINT pk_wiki_tags PRIMARY KEY (id)
);
CREATE INDEX idx_wiki_tags_tag_type ON wiki_tags(tag_type);
CREATE INDEX idx_wiki_tags_type_space ON wiki_tags(tag_type, space_id);
CREATE INDEX idx_wiki_tags_type_user ON wiki_tags(tag_type, create_user_id);

CREATE TABLE wiki_page_tags (
    id BIGINT NOT NULL IDENTITY(1,1),
    tag_id BIGINT NULL,
    space_id BIGINT NULL,
    page_id BIGINT NULL,
    created TIMESTAMP NULL,
    create_user_id BIGINT NULL,
    create_user VARCHAR2(50 CHAR) NULL,
    yn NUMBER(1) DEFAULT 1 NOT NULL,
    CONSTRAINT pk_wiki_page_tags PRIMARY KEY (id)
);
CREATE UNIQUE INDEX idx_wiki_page_tags_tag_page ON wiki_page_tags(tag_id, space_id, page_id);

CREATE TABLE ai_third_party_sync (
    id BIGINT NOT NULL IDENTITY(1,1),
    space_id BIGINT,
    name VARCHAR(20),
    sync_type SMALLINT NOT NULL,
    api_key VARCHAR(128),
    created DATETIME,
    create_user_id BIGINT,
    create_user VARCHAR(50),
    modified DATETIME,
    modify_user_id BIGINT,
    modify_user VARCHAR(50),
    yn SMALLINT DEFAULT 1 NOT NULL,
    CONSTRAINT pk_ai_third_party_sync PRIMARY KEY (id)
);
CREATE INDEX idx_ai_third_party_sync_space_id ON AI_THIRD_PARTY_SYNC(space_id);

CREATE TABLE ai_qywx_kf_msg (
    id BIGINT NOT NULL IDENTITY(1,1),
    open_kf_id VARCHAR(50),
    next_cursor VARCHAR(100),
    msg_id VARCHAR(50),
    external_userid VARCHAR(50),
    msg_type VARCHAR(50),
    text_content VARCHAR(1024),
    send_time DATETIME,
    origin INTEGER,
    servicer_userid VARCHAR(50),
    event_type VARCHAR(50),
    welcome_code VARCHAR(100),
    msg_status SMALLINT DEFAULT 0 NOT NULL,
    CONSTRAINT pk_ai_qywx_kf_msg PRIMARY KEY (id)
);
CREATE INDEX idx_ai_qywx_kf_msg_open_kf_id ON ai_qywx_kf_msg(open_kf_id);

-- ！！注意！！新加的表时必须加入到备份任务中去

-- -------------------插入必要的数据-------------------
-- 用户信息
INSERT INTO user_info (user_no, password, user_name, email, del_flag, creation_time, update_time, sex)
VALUES ('admin', 'e10adc3949ba59abbe56e057f20f883e', '系统管理员', 'admin@aibp.work', 0, '2018-12-01 11:37:39', '2018-12-01 11:37:39', 1);
-- 权限列表
INSERT INTO auth_info (auth_name, auth_desc, can_edit, create_uid, creation_time, auth_type)
VALUES ('SYSTEM_MANAGE', '系统管理权', 0, 1, '2018-12-01 11:37:39', 1),
       ('WIKI_CREATE_SPACE', '空间创建权', 0, 1, '2022-12-10 11:37:39', 1),
       ('INTEGRATE_MANAGE', '文集管理权', 0, 1, '2024-02-29 15:26:17', 1),
       ('AI_APP_MANAGE', 'AI应用管理权', 0, 1, '2024-08-15 15:26:17', 1),
       ('USER_MANAGE', '用户管理权', 0, 1, '2025-05-14 15:26:17', 1);

-- 用户权限
INSERT INTO user_auth ( user_id, auth_id, create_uid, update_uid, del_flag, creation_time)
VALUES (1, 1, 1, 1, 0, '2018-12-01 11:37:39'),
       (1, 2, 1, 1, 0, '2018-12-01 11:37:39'),
       (1, 3, 1, 1, 0, '2018-12-01 11:37:39'),
       (1, 4, 1, 1, 0, '2018-12-01 11:37:39'),
       (1, 5, 1, 1, 0, '2018-12-01 11:37:39');

-- 背景色
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Gradient',3,'#a8edea,#fed6e3',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Gradient',3,'#9795f0,#fbc8d4',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Gradient',3,'#fad0c4,#ffd1ff',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Gradient',3,'#fbc2eb,#a6c1ee',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Gradient',3,'#a6c0fe,#f68084',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Gradient',3,'#e0c3fc,#8ec5fc',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Pure',2,'#CC9999',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Pure',2,'#FF6666',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Pure',2,'#0099CC',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Pure',2,'#CC3399',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Pure',2,'#FF9900',1,now(),now(),1);
insert into wiki_space_background(tag_name,config_type,background,color_type,created,modified,yn) values ('Pure',2,'#99CC00',1,now(),now(),1);
