/**
 * AI问答聊天窗口，懒得压缩混淆，你也难得解密，有看的上的就借鉴去用吧
 * @author zyplayer-doc
 * @date 2024-08-15
 */
const chatUiHtml = `
<div class="zy-chat-btn">
    <img src="${placeholder.entranceIcon}"/>
</div>
<div class="zy-chat-box">
    <iframe src="${placeholder.chatUrl}"></iframe>
    <div class="zy-chat-actions">
        <div class="zy-chat-full-off">
            <svg width="20" height="20" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M41 19H29V7" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M18 6H6V18" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M30 42H42V30" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M7 29H19V41" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M42 6L29 19" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M19 29L6 42" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/></svg>
        </div>
        <div class="zy-chat-full">
            <svg width="20" height="20" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M30 6H42V18" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M18 6H6V18" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M30 42H42V30" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M18 42H6V30" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M42 6L29 19" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M19 29L6 42" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/></svg>
        </div>
        <div class="zy-chat-close">
            <svg width="20" height="20" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8 8L40 40" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M8 40L40 8" stroke="#333" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/></svg>
        </div>
    </div>
</div>
`;
const chatUiCss = `
.zy-chat-ui .zy-chat-btn {
    z-index: 100000;
    height: 50px;
    width: 50px;
    position: fixed;
    bottom: 50px;
    right: 30px;
    cursor: pointer;
}
.zy-chat-ui .zy-chat-btn img {
    height: 100%;
    width: 100%;
}
.zy-chat-ui .zy-chat-box {
    z-index: 100001;
    position: fixed;
    bottom: 20px;
    right: 20px;
    overflow: hidden;
    border-radius: 8px;
    box-shadow: 0 1px 2px -2px rgba(0, 0, 0, 0.16), 0 3px 6px 0 rgba(0, 0, 0, 0.12), 0 5px 12px 4px rgba(0, 0, 0, 0.09);
    background: #fff;
    border: 1px solid #eee;
    width: 420px;
    max-width: 840px;
    height: 666px;
    max-height: 80%;
    display: none;
}
.zy-chat-ui .zy-chat-box.show {
    display: block;
}
.zy-chat-ui .zy-chat-box.full {
    width: 100%;
    height: 100%;
    max-height: 100%;
    right: 0;
    bottom: 0;
}
@media only screen and (max-width: 768px) {
    .zy-chat-ui .zy-chat-box {
        bottom: 0px;
        right: 0px;
        width: 100%;
        height: 80%;
        top: unset;
    }
}
.zy-chat-ui .zy-chat-box iframe {
    height: 100%;
    width: 100%;
    border: none;
}
.zy-chat-ui .zy-chat-box .zy-chat-actions {
    display: flex;
    position: absolute;
    align-items: center;
    top: 22px;
    right: 20px;
}
.zy-chat-ui .zy-chat-box .zy-chat-actions .zy-chat-full-off {
    cursor: pointer;
    display: none;
}
.zy-chat-ui .zy-chat-box .zy-chat-actions .zy-chat-full {
    cursor: pointer;
    display: block;
}
.zy-chat-ui .zy-chat-box .zy-chat-actions .zy-chat-close {
    cursor: pointer;
    margin-left: 15px;
}
.zy-chat-ui .zy-chat-box.full .zy-chat-actions .zy-chat-full-off {
    display: block;
}
.zy-chat-ui .zy-chat-box.full .zy-chat-actions .zy-chat-full {
    display: none;
}
`;

function zyplayerChatInit() {
    const chatUi = document.createElement('div');
    chatUi.classList.add('zy-chat-ui');
    document.body.appendChild(chatUi);
    const style = document.createElement('style');
    style.innerHTML = chatUiCss;
    chatUi.appendChild(style);
    chatUi.insertAdjacentHTML("beforeend", chatUiHtml);
    const chatBox = chatUi.querySelector('.zy-chat-box');
    const chatBtn = chatUi.querySelector('.zy-chat-btn');
    const closeBtn = chatUi.querySelector('.zy-chat-close');
    const fullBtn = chatUi.querySelector('.zy-chat-full');
    const fullOffBtn = chatUi.querySelector('.zy-chat-full-off');
    chatBtn.onclick = function () {
        chatBox.classList.add('show');
    };
    closeBtn.onclick = function () {
        chatBox.classList.remove('show');
    };
    fullBtn.onclick = function () {
        chatBox.classList.add('full');
    };
    fullOffBtn.onclick = function () {
        chatBox.classList.remove('full');
    };
}

window.onload = zyplayerChatInit;
