/*
 * Decompiled with CFR 0.152.
 */
package com.zyplayer.doc.x.hc;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.zyplayer.doc.x.fy.a;
import com.zyplayer.doc.x.gs.c;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@MapperScan(value={"com.zyplayer.doc.data.repository.manage.mapper"}, sqlSessionFactoryRef="manageSqlSessionFactory")
public class b {
    @Value(value="${aibp.doc.manage.datasource.type:mysql}")
    public String dbType;
    @Value(value="${aibp.doc.manage.datasource.driverClassName}")
    public String driverClassName;
    @Value(value="${aibp.doc.manage.datasource.url}")
    public String url;
    @Value(value="${aibp.doc.manage.datasource.username}")
    public String username;
    @Value(value="${aibp.doc.manage.datasource.password}")
    public String password;
    @Value(value="${aibp.doc.manage.debugger.sql:false}")
    public boolean debuggerSql;

    @Bean(name={"manageDatasource"})
    public DataSource hy() throws Exception {
        return c.createDataSource((String)this.driverClassName, (String)this.url, (String)this.username, (String)this.password, (boolean)false);
    }

    @Bean(name={"manageSqlSessionFactory"})
    public MybatisSqlSessionFactoryBean a(@Qualifier(value="manageDatasource") DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean mybatisSqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
        mybatisSqlSessionFactoryBean.setDataSource(dataSource);
        DbType dbType = DbType.MYSQL;
        String string = "classpath:/mapper/mysql/*Mapper.xml";
        if (Objects.equals(this.dbType, DbType.DM.getDb())) {
            dbType = DbType.DM;
            string = "classpath:/mapper/dm/*Mapper.xml";
        }
        MybatisPlusInterceptor mybatisPlusInterceptor = new MybatisPlusInterceptor();
        mybatisPlusInterceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(dbType));
        String string2 = new ApplicationHome(this.getClass()).getSource().getPath();
        if (string2.endsWith(".jar") && !this.debuggerSql) {
            mybatisSqlSessionFactoryBean.setPlugins(new Interceptor[]{mybatisPlusInterceptor});
        } else {
            mybatisSqlSessionFactoryBean.setPlugins(new Interceptor[]{new a(), mybatisPlusInterceptor});
        }
        PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
        mybatisSqlSessionFactoryBean.setMapperLocations(pathMatchingResourcePatternResolver.getResources(string));
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setBanner(false);
        mybatisSqlSessionFactoryBean.setGlobalConfig(globalConfig);
        return mybatisSqlSessionFactoryBean;
    }
}

