/*
 * Decompiled with CFR 0.152.
 */
package com.zyplayer.doc.x.ha;

import cn.hutool.core.io.IoUtil;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.zyplayer.doc.x.gs.f;
import com.zyplayer.doc.x.ha.a;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/*
 * Exception performing whole class analysis ignored.
 */
public class a {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWorkbook(JSONObject workbookJson, OutputStream out) throws IOException {
        Objects.requireNonNull(workbookJson, "workbookJson NULL");
        try (XSSFWorkbook xSSFWorkbook = new XSSFWorkbook();){
            c c2 = new c(xSSFWorkbook, workbookJson);
            a.parseWorkbook((c)c2);
            xSSFWorkbook.write(out);
        }
    }

    public static void writeWorkbook(String workbookJsonStr, OutputStream out) throws IOException {
        a.writeWorkbook((JSONObject)JSON.parseObject((String)workbookJsonStr), (OutputStream)out);
    }

    public static void writeWorkbook(JSONObject workbookJson, Path file) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);){
            a.writeWorkbook((JSONObject)workbookJson, (OutputStream)outputStream);
        }
    }

    private static void parseWorkbook(c ctx) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = ctx.workbookJson;
        a.parseDrawingPluginData((c)ctx, (JSONArray)jSONObject2.getJSONArray("resources"));
        String string = jSONObject2.getString("name");
        if (string == null) {
            string = "Workbook";
        }
        JSONObject jSONObject3 = jSONObject2.getJSONObject("styles");
        ArrayList<String> arrayList = new ArrayList<String>();
        JSONArray jSONArray = jSONObject2.getJSONArray("sheetOrder");
        if (jSONArray != null) {
            for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
                arrayList.add(jSONArray.getString(i2));
            }
        }
        if ((jSONObject = jSONObject2.getJSONObject("sheets")) == null) {
            return;
        }
        int n2 = 0;
        for (String string2 : arrayList) {
            JSONObject jSONObject4 = jSONObject.getJSONObject(string2);
            if (jSONObject4 == null) continue;
            a.buildSheet((c)ctx, (JSONObject)jSONObject4, (int)n2++, (JSONObject)jSONObject3);
        }
        for (String string2 : jSONObject.keySet()) {
            if (arrayList.contains(string2)) continue;
            a.buildSheet((c)ctx, (JSONObject)jSONObject.getJSONObject(string2), (int)n2++, (JSONObject)jSONObject3);
        }
    }

    private static void buildSheet(c ctx, JSONObject sheetJson, int sheetIndex, JSONObject stylesJson) {
        List list;
        String string;
        JSONArray jSONArray;
        JSONObject jSONObject;
        List list2;
        JSONObject jSONObject2;
        Object object2;
        JSONObject jSONObject3;
        int n2;
        int n3;
        XSSFColor xSSFColor;
        XSSFWorkbook xSSFWorkbook = ctx.wb;
        String string2 = sheetJson.getString("name");
        if (StringUtils.isBlank((CharSequence)string2)) {
            string2 = "Sheet" + (sheetIndex + 1);
        }
        XSSFSheet xSSFSheet = xSSFWorkbook.createSheet(string2);
        String string3 = sheetJson.getString("tabColor");
        if (StringUtils.isNotBlank((CharSequence)string3) && (xSSFColor = a.parseColor((String)string3)) != null) {
            xSSFSheet.setTabColor(xSSFColor);
        }
        if (sheetJson.getInteger("hidden") != null && sheetJson.getIntValue("hidden") == 1) {
            xSSFWorkbook.setSheetHidden(xSSFWorkbook.getSheetIndex((Sheet)xSSFSheet), true);
        }
        if ((xSSFColor = sheetJson.getJSONObject("freeze")) != null) {
            n3 = xSSFColor.getIntValue("xSplit");
            n2 = xSSFColor.getIntValue("ySplit");
            int n4 = xSSFColor.getIntValue("startRow");
            int n5 = xSSFColor.getIntValue("startColumn");
            if (n3 > 0 || n2 > 0) {
                xSSFSheet.createFreezePane(n3, n2, Math.max(n5, n3), Math.max(n4, n2));
            }
        }
        if (sheetJson.containsKey("showGridlines")) {
            xSSFSheet.setDisplayGridlines(sheetJson.getIntValue("showGridlines") == 1);
        }
        if (sheetJson.containsKey("rightToLeft")) {
            xSSFSheet.setRightToLeft(sheetJson.getIntValue("rightToLeft") == 1);
        }
        if ((n3 = sheetJson.getIntValue("defaultColumnWidth")) > 0) {
            n2 = a.pxToColumnWidthUnits((int)n3);
            xSSFSheet.setDefaultColumnWidth(Math.max(1, n2 / 256));
        }
        if ((n2 = sheetJson.getIntValue("defaultRowHeight")) > 0) {
            float f2 = a.pxToPoints((int)n2);
            xSSFSheet.setDefaultRowHeightInPoints(f2);
        }
        if ((jSONObject3 = sheetJson.getJSONObject("columnData")) != null) {
            for (Object object2 : jSONObject3.keySet()) {
                int n6 = a.parseIntSafe((String)object2, (int)-1);
                if (n6 < 0) continue;
                JSONObject jSONObject4 = jSONObject3.getJSONObject((String)object2);
                int n7 = jSONObject4.getIntValue("w");
                if (n7 > 0) {
                    xSSFSheet.setColumnWidth(n6, a.pxToColumnWidthUnits((int)n7));
                }
                if (jSONObject4.getIntValue("hd") != 1) continue;
                xSSFSheet.setColumnHidden(n6, true);
            }
        }
        if ((jSONObject2 = sheetJson.getJSONObject("rowData")) != null) {
            for (String string4 : jSONObject2.keySet()) {
                int n8;
                int n9 = a.parseIntSafe((String)string4, (int)-1);
                if (n9 < 0) continue;
                JSONObject jSONObject5 = jSONObject2.getJSONObject(string4);
                list2 = xSSFSheet.getRow(n9);
                if (list2 == null) {
                    list2 = xSSFSheet.createRow(n9);
                }
                if ((n8 = jSONObject5.getIntValue("h")) > 0) {
                    list2.setHeightInPoints(a.pxToPoints((int)n8));
                }
                if (jSONObject5.getIntValue("hd") != 1) continue;
                list2.setZeroHeight(true);
            }
        }
        object2 = sheetJson.getJSONObject("defaultStyle");
        CellStyle cellStyle = null;
        if (object2 != null) {
            cellStyle = a.buildOrGetStyle((c)ctx, (JSONObject)object2, null);
        }
        if ((jSONObject = sheetJson.getJSONObject("cellData")) != null) {
            HashMap hashMap = new HashMap();
            list2 = a.numericKeys((JSONObject)jSONObject);
            for (Integer n10 : list2) {
                JSONObject jSONObject6 = jSONObject.getJSONObject(String.valueOf(n10));
                if (jSONObject6 == null) continue;
                XSSFRow xSSFRow = xSSFSheet.getRow(n10.intValue());
                if (xSSFRow == null) {
                    xSSFRow = xSSFSheet.createRow(n10.intValue());
                }
                List list3 = a.numericKeys((JSONObject)jSONObject6);
                for (Integer n11 : list3) {
                    JSONObject jSONObject7 = jSONObject6.getJSONObject(String.valueOf(n11));
                    if (jSONObject7 == null) continue;
                    XSSFCell xSSFCell = xSSFRow.getCell(n11.intValue());
                    if (xSSFCell == null) {
                        xSSFCell = xSSFRow.createCell(n11.intValue());
                    }
                    a.applyCellStyle((c)ctx, (JSONObject)stylesJson, (JSONObject)jSONObject7, (XSSFCell)xSSFCell, (CellStyle)cellStyle);
                    a.applyCellValueAndType((JSONObject)jSONObject7, (XSSFCell)xSSFCell, hashMap, (c)ctx);
                }
            }
        }
        if ((jSONArray = sheetJson.getJSONArray("mergeData")) != null) {
            for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
                int n12;
                int n13;
                int n14;
                JSONObject jSONObject8 = jSONArray.getJSONObject(i2);
                if (jSONObject8 == null) continue;
                int n15 = jSONObject8.containsKey("startRow") ? jSONObject8.getIntValue("startRow") : jSONObject8.getIntValue("r");
                int n16 = n14 = jSONObject8.containsKey("startColumn") ? jSONObject8.getIntValue("startColumn") : jSONObject8.getIntValue("c");
                int n17 = jSONObject8.containsKey("endRow") ? jSONObject8.getIntValue("endRow") : (n13 = jSONObject8.containsKey("rs") ? n15 + jSONObject8.getIntValue("rs") - 1 : n15);
                int n18 = jSONObject8.containsKey("endColumn") ? jSONObject8.getIntValue("endColumn") : (n12 = jSONObject8.containsKey("cs") ? n14 + jSONObject8.getIntValue("cs") - 1 : n14);
                if (n15 < 0 || n14 < 0 || n13 < n15 || n12 < n14) continue;
                try {
                    xSSFSheet.addMergedRegion(new CellRangeAddress(n15, n13, n14, n12));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(string = sheetJson.getString("id"))) && (list = (List)ctx.sheetDrawings.get(string)) != null && !list.isEmpty()) {
            for (b b2 : list) {
                a.placeSheetDrawing((c)ctx, (XSSFSheet)xSSFSheet, (b)b2);
            }
        }
        if (jSONObject != null) {
            a.addCellRichTextDrawings((c)ctx, (XSSFSheet)xSSFSheet, (JSONObject)jSONObject);
        }
    }

    private static void parseDrawingPluginData(c ctx, JSONArray resourcesArr) {
        if (resourcesArr == null) {
            return;
        }
        for (int i2 = 0; i2 < resourcesArr.size(); ++i2) {
            JSONObject jSONObject;
            String string;
            JSONObject jSONObject2 = resourcesArr.getJSONObject(i2);
            if (jSONObject2 == null || !"SHEET_DRAWING_PLUGIN".equals(jSONObject2.getString("name")) || StringUtils.isBlank((CharSequence)(string = jSONObject2.getString("data")))) continue;
            try {
                jSONObject = JSON.parseObject((String)string);
            }
            catch (Exception exception) {
                continue;
            }
            for (String string2 : jSONObject.keySet()) {
                JSONObject jSONObject3;
                JSONObject jSONObject4 = jSONObject.getJSONObject(string2);
                if (jSONObject4 == null || (jSONObject3 = jSONObject4.getJSONObject("data")) == null) continue;
                for (String string3 : jSONObject3.keySet()) {
                    JSONObject jSONObject5 = jSONObject3.getJSONObject(string3);
                    if (jSONObject5 == null) continue;
                    String string4 = jSONObject5.getString("source");
                    String string5 = jSONObject5.getString("imageSourceType");
                    JSONObject jSONObject6 = jSONObject5.getJSONObject("sheetTransform");
                    if (jSONObject6 == null) continue;
                    JSONObject jSONObject7 = jSONObject6.getJSONObject("from");
                    JSONObject jSONObject8 = jSONObject6.getJSONObject("to");
                    if (jSONObject7 == null || jSONObject8 == null) continue;
                    b b2 = new b(null);
                    b2.sheetId = string2;
                    b2.url = string4;
                    b2.imageSourceType = string5;
                    b2.col1 = jSONObject7.getIntValue("column");
                    b2.row1 = jSONObject7.getIntValue("row");
                    b2.col2 = jSONObject8.getIntValue("column");
                    b2.row2 = jSONObject8.getIntValue("row");
                    b2.dx1Px = (int)Math.round(jSONObject7.getDoubleValue("columnOffset"));
                    b2.dy1Px = (int)Math.round(jSONObject7.getDoubleValue("rowOffset"));
                    b2.dx2Px = (int)Math.round(jSONObject8.getDoubleValue("columnOffset"));
                    b2.dy2Px = (int)Math.round(jSONObject8.getDoubleValue("rowOffset"));
                    ctx.sheetDrawings.computeIfAbsent(string2, k2 -> new ArrayList()).add(b2);
                }
            }
        }
    }

    private static void addCellRichTextDrawings(c ctx, XSSFSheet sheet, JSONObject cellData) {
        List list = a.numericKeys((JSONObject)cellData);
        for (Integer n2 : list) {
            JSONObject jSONObject = cellData.getJSONObject(String.valueOf(n2));
            if (jSONObject == null) continue;
            List list2 = a.numericKeys((JSONObject)jSONObject);
            for (Integer n3 : list2) {
                JSONObject jSONObject2;
                JSONObject jSONObject3 = jSONObject.getJSONObject(String.valueOf(n3));
                if (jSONObject3 == null || (jSONObject2 = jSONObject3.getJSONObject("p")) == null) continue;
                JSONObject jSONObject4 = jSONObject2.getJSONObject("drawings");
                JSONArray jSONArray = jSONObject2.getJSONArray("drawingsOrder");
                if (jSONObject4 == null || jSONArray == null || jSONArray.isEmpty()) continue;
                for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
                    String string = jSONArray.getString(i2);
                    JSONObject jSONObject5 = jSONObject4.getJSONObject(string);
                    if (jSONObject5 == null) continue;
                    String string2 = jSONObject5.getString("source");
                    String string3 = jSONObject5.getString("imageSourceType");
                    JSONObject jSONObject6 = jSONObject5.getJSONObject("transform");
                    double d2 = jSONObject6 != null ? jSONObject6.getDoubleValue("width") : 0.0;
                    double d3 = jSONObject6 != null ? jSONObject6.getDoubleValue("height") : 0.0;
                    a.placeCellDrawing((c)ctx, (XSSFSheet)sheet, (int)n2, (int)n3, (String)string2, (String)string3, (double)d2, (double)d3);
                }
            }
        }
    }

    private static void placeSheetDrawing(c ctx, XSSFSheet sheet, b di) {
        if (StringUtils.isBlank((CharSequence)di.url)) {
            return;
        }
        try {
            int n2 = a.getOrRegisterPicture((c)ctx, (String)di.url, (String)di.imageSourceType);
            if (n2 < 0) {
                return;
            }
            XSSFDrawing xSSFDrawing = sheet.createDrawingPatriarch();
            XSSFClientAnchor xSSFClientAnchor = new XSSFClientAnchor();
            xSSFClientAnchor.setCol1(di.col1);
            xSSFClientAnchor.setRow1(di.row1);
            xSSFClientAnchor.setCol2(Math.max(di.col1, di.col2));
            xSSFClientAnchor.setRow2(Math.max(di.row1, di.row2));
            xSSFClientAnchor.setDx1(di.dx1Px * 9525);
            xSSFClientAnchor.setDy1(di.dy1Px * 9525);
            xSSFClientAnchor.setDx2(di.dx2Px * 9525);
            xSSFClientAnchor.setDy2(di.dy2Px * 9525);
            xSSFDrawing.createPicture(xSSFClientAnchor, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void placeCellDrawing(c ctx, XSSFSheet sheet, int row, int col, String url, String imageSourceType, double widthPx, double heightPx) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        try {
            int n2 = a.getOrRegisterPicture((c)ctx, (String)url, (String)imageSourceType);
            if (n2 < 0) {
                return;
            }
            XSSFDrawing xSSFDrawing = sheet.createDrawingPatriarch();
            XSSFClientAnchor xSSFClientAnchor = new XSSFClientAnchor();
            xSSFClientAnchor.setCol1(col);
            xSSFClientAnchor.setRow1(row);
            xSSFClientAnchor.setCol2(col + 1);
            xSSFClientAnchor.setRow2(row + 1);
            XSSFPicture xSSFPicture = xSSFDrawing.createPicture(xSSFClientAnchor, n2);
            if (widthPx > 0.0 && heightPx > 0.0) {
                double d2 = sheet.getColumnWidthInPixels(col);
                double d3 = a.getRowHeightInPixels((XSSFSheet)sheet, (int)row);
                if (d2 <= 0.0) {
                    d2 = 64.0;
                }
                if (d3 <= 0.0) {
                    d3 = 20.0;
                }
                double d4 = widthPx / d2;
                double d5 = heightPx / d3;
                xSSFPicture.resize(d4, d5);
            } else {
                xSSFPicture.resize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static double getRowHeightInPixels(XSSFSheet sheet, int rowIdx) {
        XSSFRow xSSFRow = sheet.getRow(rowIdx);
        float f2 = xSSFRow != null && xSSFRow.getHeightInPoints() > 0.0f ? xSSFRow.getHeightInPoints() : sheet.getDefaultRowHeightInPoints();
        return (double)(f2 * 96.0f) / 72.0;
    }

    private static int getOrRegisterPicture(c ctx, String source, String imageSourceType) {
        String string = imageSourceType + ":" + source;
        Integer n2 = (Integer)ctx.pictureIndexCache.get(string);
        if (n2 != null) {
            return n2;
        }
        byte[] byArray = null;
        byArray = "BASE64".equals(imageSourceType) ? a.decodeBase64Image((String)source) : a.downloadImage((String)source);
        if (byArray == null || byArray.length == 0) {
            return -1;
        }
        int n3 = a.detectPictureType((String)source, (String)imageSourceType);
        int n4 = ctx.wb.addPicture(byArray, n3);
        ctx.pictureIndexCache.put(string, n4);
        return n4;
    }

    private static byte[] decodeBase64Image(String base64Data) {
        if (StringUtils.isBlank((CharSequence)base64Data)) {
            return null;
        }
        try {
            String string = base64Data;
            if (base64Data.contains(",")) {
                string = base64Data.substring(base64Data.indexOf(",") + 1);
            }
            return Base64.getDecoder().decode(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static int detectPictureType(String source, String imageSourceType) {
        if ("BASE64".equals(imageSourceType)) {
            if (source.contains("data:image/")) {
                String string = source.substring(0, source.indexOf(";"));
                if (string.contains("png")) {
                    return 6;
                }
                if (string.contains("jpeg") || string.contains("jpg")) {
                    return 5;
                }
                if (string.contains("bmp")) {
                    return 7;
                }
            }
            return 6;
        }
        return a.detectPictureType((String)source);
    }

    private static int detectPictureType(String url) {
        String string = url.toLowerCase(Locale.ROOT);
        if (string.endsWith(".png")) {
            return 6;
        }
        if (string.endsWith(".jpg") || string.endsWith(".jpeg")) {
            return 5;
        }
        if (string.endsWith(".bmp")) {
            return 7;
        }
        return 6;
    }

    private static byte[] downloadImage(String urlStr) {
        if (StringUtils.isBlank((CharSequence)urlStr)) {
            return null;
        }
        HttpResponse httpResponse = f.downloadFile((String)urlStr, (int)10000);
        if (!httpResponse.isOk()) {
            return null;
        }
        return IoUtil.readBytes((InputStream)httpResponse.bodyStream());
    }

    private static void applyCellValueAndType(JSONObject cellJson, XSSFCell cell, Map<String, String> formulaRepo, c ctx) {
        if (cellJson.containsKey("p")) {
            JSONObject jSONObject = cellJson.getJSONObject("p");
            String string = a.extractPlainTextFromRich((JSONObject)jSONObject);
            cell.setCellValue(string);
            return;
        }
        String string = cellJson.getString("f");
        String string2 = cellJson.getString("si");
        if (!StringUtils.isBlank((CharSequence)string)) {
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            cell.setCellFormula(string);
            if (!StringUtils.isBlank((CharSequence)string2)) {
                formulaRepo.putIfAbsent(string2, string);
            }
            if (cellJson.containsKey("v")) {
                Object object = cellJson.get("v");
                a.setCellValueByInferredType((XSSFCell)cell, (Object)object);
            }
            return;
        }
        if (!StringUtils.isBlank((CharSequence)string2)) {
            String string3 = formulaRepo.get(string2);
            if (string3 != null) {
                cell.setCellFormula(string3);
            }
            if (cellJson.containsKey("v")) {
                Object object = cellJson.get("v");
                a.setCellValueByInferredType((XSSFCell)cell, (Object)object);
            }
            return;
        }
        if (cellJson.containsKey("v")) {
            Object object = cellJson.get("v");
            int n2 = cellJson.getIntValue("t");
            switch (n2) {
                case 1: {
                    cell.setCellValue(a.safeString((Object)object));
                    break;
                }
                case 2: {
                    Double d2 = a.toDouble((Object)object);
                    if (d2 != null) {
                        cell.setCellValue(d2.doubleValue());
                        break;
                    }
                    cell.setCellValue(a.safeString((Object)object));
                    break;
                }
                case 3: {
                    boolean bl = "1".equals(String.valueOf(object)) || Boolean.TRUE.equals(object);
                    cell.setCellValue(bl);
                    break;
                }
                case 4: {
                    cell.setCellValue(a.safeString((Object)object));
                    a.ensureTextDataFormat((XSSFCell)cell);
                    break;
                }
                default: {
                    a.setCellValueByInferredType((XSSFCell)cell, (Object)object);
                }
            }
        }
    }

    private static void setCellValueByInferredType(XSSFCell cell, Object v2) {
        if (v2 == null) {
            cell.setBlank();
            return;
        }
        if (v2 instanceof Number) {
            cell.setCellValue(((Number)v2).doubleValue());
        } else if (v2 instanceof Boolean) {
            cell.setCellValue(((Boolean)v2).booleanValue());
        } else {
            String string = v2.toString();
            Double d2 = a.toDouble((Object)v2);
            if (d2 != null && string.matches("-?\\d+(\\.\\d+)?")) {
                cell.setCellValue(d2.doubleValue());
            } else {
                cell.setCellValue(string);
            }
        }
    }

    private static void ensureTextDataFormat(XSSFCell cell) {
        XSSFCellStyle xSSFCellStyle = cell.getCellStyle();
        if (xSSFCellStyle == null || xSSFCellStyle == cell.getSheet().getWorkbook().createCellStyle()) {
            return;
        }
        short s2 = cell.getSheet().getWorkbook().createDataFormat().getFormat("@");
        if (xSSFCellStyle.getDataFormat() != s2) {
            XSSFCellStyle xSSFCellStyle2 = cell.getSheet().getWorkbook().createCellStyle();
            xSSFCellStyle2.cloneStyleFrom((CellStyle)xSSFCellStyle);
            xSSFCellStyle2.setDataFormat(s2);
            cell.setCellStyle((CellStyle)xSSFCellStyle2);
        }
    }

    private static String extractPlainTextFromRich(JSONObject rich) {
        String string;
        if (rich == null) {
            return "";
        }
        JSONObject jSONObject = rich.getJSONObject("body");
        if (jSONObject != null && (string = jSONObject.getString("dataStream")) != null) {
            return string;
        }
        return rich.toJSONString(new JSONWriter.Feature[0]);
    }

    private static void applyCellStyle(c ctx, JSONObject stylesJson, JSONObject cellJson, XSSFCell cell, CellStyle defaultCellStyle) {
        Object object = cellJson.get("s");
        CellStyle cellStyle = null;
        if (object instanceof String) {
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject = stylesJson == null ? null : stylesJson.getJSONObject(object.toString());
            if (jSONObject != null) {
                cellStyle = a.buildOrGetStyle((c)ctx, (JSONObject)jSONObject, (String)object.toString());
            }
        } else if (object instanceof JSONObject) {
            cellStyle = a.buildOrGetStyle((c)ctx, (JSONObject)((JSONObject)object), null);
        }
        if (cellStyle == null && defaultCellStyle != null) {
            cellStyle = defaultCellStyle;
        }
        if (cellStyle != null) {
            cell.setCellStyle(cellStyle);
        }
    }

    private static CellStyle buildOrGetStyle(c ctx, JSONObject styleJson, String styleId) {
        String string;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        int n2;
        JSONObject jSONObject3;
        int n3;
        XSSFColor xSSFColor;
        JSONObject jSONObject4;
        JSONObject jSONObject5;
        JSONObject jSONObject6;
        if (styleJson == null) {
            return null;
        }
        String string2 = styleId != null ? "ID:" + styleId : "OBJ:" + styleJson.toJSONString(new JSONWriter.Feature[0]);
        CellStyle cellStyle = (CellStyle)ctx.styleCache.get(string2);
        if (cellStyle != null) {
            return cellStyle;
        }
        XSSFWorkbook xSSFWorkbook = ctx.wb;
        XSSFCellStyle xSSFCellStyle = xSSFWorkbook.createCellStyle();
        XSSFFont xSSFFont = xSSFWorkbook.createFont();
        if (styleJson.containsKey("ff")) {
            xSSFFont.setFontName(styleJson.getString("ff"));
        }
        if (styleJson.containsKey("fs")) {
            xSSFFont.setFontHeightInPoints((short)styleJson.getIntValue("fs"));
        }
        if (styleJson.getIntValue("it") == 1) {
            xSSFFont.setItalic(true);
        }
        if (styleJson.getIntValue("bl") == 1) {
            xSSFFont.setBold(true);
        }
        if ((jSONObject6 = styleJson.getJSONObject("ul")) != null && jSONObject6.getIntValue("s") == 1) {
            xSSFFont.setUnderline((byte)1);
        }
        if ((jSONObject5 = styleJson.getJSONObject("st")) != null && jSONObject5.getIntValue("s") == 1) {
            xSSFFont.setStrikeout(true);
        }
        if ((jSONObject4 = styleJson.getJSONObject("cl")) != null && (xSSFColor = a.parseColor((String)jSONObject4.getString("rgb"))) != null) {
            xSSFFont.setColor(xSSFColor);
        }
        if ((n3 = styleJson.getIntValue("va")) == 2) {
            xSSFFont.setTypeOffset((short)2);
        } else if (n3 == 3) {
            xSSFFont.setTypeOffset((short)1);
        }
        xSSFCellStyle.setFont((Font)xSSFFont);
        JSONObject jSONObject7 = styleJson.getJSONObject("bg");
        if (jSONObject7 != null && (jSONObject3 = a.parseColor((String)jSONObject7.getString("rgb"))) != null) {
            xSSFCellStyle.setFillForegroundColor((XSSFColor)jSONObject3);
            xSSFCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if ((jSONObject3 = styleJson.getJSONObject("bd")) != null) {
            a.applyBorder((JSONObject)jSONObject3.getJSONObject("t"), (XSSFCellStyle)xSSFCellStyle, (a)a.TOP);
            a.applyBorder((JSONObject)jSONObject3.getJSONObject("b"), (XSSFCellStyle)xSSFCellStyle, (a)a.BOTTOM);
            a.applyBorder((JSONObject)jSONObject3.getJSONObject("l"), (XSSFCellStyle)xSSFCellStyle, (a)a.LEFT);
            a.applyBorder((JSONObject)jSONObject3.getJSONObject("r"), (XSSFCellStyle)xSSFCellStyle, (a)a.RIGHT);
        }
        if ((n2 = styleJson.getIntValue("ht")) == 1) {
            xSSFCellStyle.setAlignment(HorizontalAlignment.LEFT);
        } else if (n2 == 2) {
            xSSFCellStyle.setAlignment(HorizontalAlignment.CENTER);
        } else if (n2 == 3) {
            xSSFCellStyle.setAlignment(HorizontalAlignment.RIGHT);
        }
        int n4 = styleJson.getIntValue("vt");
        if (n4 == 1) {
            xSSFCellStyle.setVerticalAlignment(VerticalAlignment.TOP);
        } else if (n4 == 2) {
            xSSFCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        } else if (n4 == 3) {
            xSSFCellStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        }
        int n5 = styleJson.getIntValue("tb");
        if (n5 == 3) {
            xSSFCellStyle.setWrapText(true);
        }
        if ((jSONObject2 = styleJson.getJSONObject("tr")) != null) {
            if (jSONObject2.getIntValue("v") == 1) {
                xSSFCellStyle.setRotation((short)90);
            } else {
                int n6 = jSONObject2.getIntValue("a");
                if (n6 >= -90 && n6 <= 90) {
                    xSSFCellStyle.setRotation((short)(-n6));
                }
            }
        }
        if ((jSONObject = styleJson.getJSONObject("n")) != null && !StringUtils.isBlank((CharSequence)(string = jSONObject.getString("pattern")))) {
            short s2 = xSSFWorkbook.createDataFormat().getFormat(string);
            xSSFCellStyle.setDataFormat(s2);
        }
        ctx.styleCache.put(string2, xSSFCellStyle);
        return xSSFCellStyle;
    }

    private static void applyBorder(JSONObject sideJson, XSSFCellStyle cs, a side) {
        if (sideJson == null) {
            return;
        }
        int n2 = sideJson.getIntValue("s");
        BorderStyle borderStyle = a.mapBorderStyle((int)n2);
        XSSFColor xSSFColor = null;
        JSONObject jSONObject = sideJson.getJSONObject("cl");
        if (jSONObject != null) {
            xSSFColor = a.parseColor((String)jSONObject.getString("rgb"));
        }
        switch (1.$SwitchMap$com$zyplayer$doc$data$utils$univer$UniverReadUtil$BorderSide[side.ordinal()]) {
            case 1: {
                cs.setBorderTop(borderStyle);
                if (xSSFColor == null) break;
                cs.setTopBorderColor(xSSFColor);
                break;
            }
            case 2: {
                cs.setBorderBottom(borderStyle);
                if (xSSFColor == null) break;
                cs.setBottomBorderColor(xSSFColor);
                break;
            }
            case 3: {
                cs.setBorderLeft(borderStyle);
                if (xSSFColor == null) break;
                cs.setLeftBorderColor(xSSFColor);
                break;
            }
            case 4: {
                cs.setBorderRight(borderStyle);
                if (xSSFColor == null) break;
                cs.setRightBorderColor(xSSFColor);
            }
        }
    }

    private static BorderStyle mapBorderStyle(int s2) {
        switch (s2) {
            case 1: {
                return BorderStyle.MEDIUM;
            }
            case 2: {
                return BorderStyle.DASHED;
            }
            case 3: {
                return BorderStyle.DOTTED;
            }
            case 4: {
                return BorderStyle.DOUBLE;
            }
            case 5: {
                return BorderStyle.THICK;
            }
        }
        return BorderStyle.THIN;
    }

    private static int pxToColumnWidthUnits(int px) {
        double d2 = (double)px / 7.0;
        return (int)Math.round(d2 * 256.0);
    }

    private static float pxToPoints(int px) {
        return (float)((double)px * 0.75);
    }

    private static List<Integer> numericKeys(JSONObject obj) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string : obj.keySet()) {
            int n2 = a.parseIntSafe((String)string, (int)-1);
            if (n2 < 0) continue;
            arrayList.add(n2);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static int parseIntSafe(String s2, int def) {
        try {
            return Integer.parseInt(s2);
        }
        catch (Exception exception) {
            return def;
        }
    }

    private static Double toDouble(Object v2) {
        if (v2 == null) {
            return null;
        }
        if (v2 instanceof Number) {
            return ((Number)v2).doubleValue();
        }
        try {
            return Double.parseDouble(v2.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String safeString(Object v2) {
        return v2 == null ? "" : String.valueOf(v2);
    }

    private static XSSFColor parseColor(String hex) {
        if (StringUtils.isBlank((CharSequence)hex)) {
            return null;
        }
        String string = hex.trim();
        if (string.startsWith("rgb(") && string.endsWith(")")) {
            try {
                String[] stringArray = string.substring(4, string.length() - 1).split(",");
                if (stringArray.length == 3) {
                    int n2 = Integer.parseInt(stringArray[0].trim());
                    int n3 = Integer.parseInt(stringArray[1].trim());
                    int n4 = Integer.parseInt(stringArray[2].trim());
                    return new XSSFColor(new Color(n2, n3, n4), null);
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if (string.length() == 3) {
            string = "" + string.charAt(0) + string.charAt(0) + string.charAt(1) + string.charAt(1) + string.charAt(2) + string.charAt(2);
        }
        if (string.length() != 6) {
            return null;
        }
        try {
            int n5 = Integer.parseInt(string.substring(0, 2), 16);
            int n6 = Integer.parseInt(string.substring(2, 4), 16);
            int n7 = Integer.parseInt(string.substring(4, 6), 16);
            return new XSSFColor(new Color(n5, n6, n7), null);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

