/*
 * Decompiled with CFR 0.152.
 */
package com.zyplayer.doc.x.gd;

import cn.hutool.core.date.DateTime;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.zyplayer.doc.data.repository.manage.mapper.UserInfoMapper;
import com.zyplayer.doc.x.d.m;
import com.zyplayer.doc.x.fk.g;
import com.zyplayer.doc.x.fk.h;
import com.zyplayer.doc.x.gd.b;
import com.zyplayer.doc.x.gg.aj;
import com.zyplayer.doc.x.gg.aq;
import com.zyplayer.doc.x.gg.j;
import com.zyplayer.doc.x.gg.s;
import com.zyplayer.doc.x.gp.d;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;

@Service
public class c {
    private static final Logger tK = LoggerFactory.getLogger(c.class);
    @Value(value="${aibp.doc.manage.datasource.type:mysql}")
    public String dbType;
    @Resource
    UserInfoMapper tL;
    @Resource
    s systemConfigService;
    @Resource
    b systemAuthService;
    @Resource
    aj wikiPageContentService;
    @Resource
    aq wikiPageVersionService;
    @Resource
    j aiPageSegmentService;

    @PostConstruct
    public void init() {
        try {
            tK.info("Start checking current database DDL version");
            String string = this.systemConfigService.b(m.SYSTEM_VERSION);
            if (Objects.equals(string, "2.5.6")) {
                tK.info("Current database DDL is up to date: {}", (Object)string);
                return;
            }
            d d2 = this.systemAuthService.gk();
            if (d2 != null && d2.getUpgradeEnd() != null && DateTime.of((Date)d2.getUpgradeEnd()).isBefore(h.re)) {
                tK.error("Your system update license has expired. You cannot use this new version. Please roll back the program package and renew before upgrading the system.");
                tK.error("\u60a8\u8d2d\u4e70\u7684\u7cfb\u7edf\u66f4\u65b0\u6743\u5df2\u8fc7\u671f\uff0c\u4e0d\u80fd\u518d\u4f7f\u7528\u6b64\u65b0\u7248\u672c\uff0c\u8bf7\u5148\u56de\u9000\u7a0b\u5e8f\u5305\u5e76\u7eed\u8d39\u540e\u518d\u5347\u7ea7\u7cfb\u7edf\u3002");
                System.exit(0);
            }
            List list = this.tL.getTableList();
            if (StringUtils.isBlank((CharSequence)string)) {
                if (CollectionUtils.isEmpty((Collection)list)) {
                    this.gt();
                } else {
                    this.gu();
                }
            } else {
                this.f(string, list);
            }
            List list2 = h.fz();
            g g3 = list2.stream().filter(g2 -> Objects.equals(g2.getVersion(), string)).findFirst().orElse(null);
            if (g3 != null && DateTime.of((String)g3.fy(), (String)"yyyy-MM-dd").isBefore((Date)DateTime.of((String)"2025-07-01", (String)"yyyy-MM-dd"))) {
                this.wikiPageContentService.gy();
                this.wikiPageVersionService.gy();
                this.aiPageSegmentService.gy();
            }
            this.systemConfigService.a(m.SYSTEM_VERSION, "2.5.6");
        }
        catch (Exception exception) {
            tK.error("Failed to execute upgrade SQL. Please manually execute the upgrade SQL or modify the version record in the system_config table to: {}. Exception: {}", new Object[]{"2.5.6", exception.getMessage(), exception});
        }
    }

    public void gt() {
        tK.info("Start initializing database DDL script");
        String string = this.W("sql/" + this.dbType + "/full/full.sql");
        if (StringUtils.isBlank((CharSequence)string)) {
            tK.error("Failed to initialize database DDL script. No executable DDL script file found");
            return;
        }
        for (String string2 : string.split(";")) {
            if (StringUtils.isBlank((CharSequence)string2)) continue;
            try {
                this.tL.executeSql(string2);
            }
            catch (Exception exception) {
                tK.info("Exception occurred while executing upgrade SQL: " + exception.getMessage());
            }
        }
        tK.info("Database DDL script initialization completed");
    }

    public void f(String string, List<String> list) {
        tK.info("Upgrade database DDL script: {} --> {}", (Object)string, (Object)"2.5.6");
        boolean bl = false;
        List list2 = h.fz();
        for (int i2 = list2.size() - 1; i2 >= 0; --i2) {
            g g2 = (g)list2.get(i2);
            if (!bl) {
                if (!Objects.equals(g2.getVersion(), string)) continue;
                bl = true;
                continue;
            }
            this.g(g2.getVersion(), list);
        }
        tK.info("Database DDL script upgrade completed");
    }

    public void g(String string, List<String> list) {
        tK.info("Start upgrading database DDL script: " + string);
        String string2 = this.W("sql/" + this.dbType + "/upgrade/" + string + ".sql");
        if (StringUtils.isBlank((CharSequence)string2)) {
            tK.info("No database DDL script for this version, skipping: " + string);
            return;
        }
        for (String string3 : string2.split(";")) {
            if (StringUtils.isBlank((CharSequence)string3)) continue;
            try {
                this.tL.executeSql(string3);
            }
            catch (Exception exception) {
                tK.info("Exception occurred while executing upgrade SQL: " + exception.getMessage());
            }
        }
        tK.info("Database DDL script upgrade completed: " + string);
    }

    public void gu() {
        tK.info("Initial upgrade database DDL script: {} --> {}", (Object)"2.0.0", (Object)"2.5.6");
        List list = h.fz();
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            g g2 = (g)list.get(i2);
            String string = this.W("sql/" + this.dbType + "/upgrade/" + g2.getVersion() + ".sql");
            if (StringUtils.isBlank((CharSequence)string)) {
                tK.info("No DDL script for this version, skipping: " + g2.getVersion());
                continue;
            }
            for (String string2 : string.split(";")) {
                if (StringUtils.isBlank((CharSequence)string2)) continue;
                try {
                    this.tL.executeSql(string2);
                }
                catch (Exception exception) {
                    tK.info("Exception occurred while executing upgrade SQL: " + exception.getMessage());
                }
            }
        }
        tK.info("Database DDL script upgrade completed: 2.5.6");
    }

    public void a(SQLStatement sQLStatement, List<String> list) {
        if (!(sQLStatement instanceof SQLCreateTableStatement)) {
            return;
        }
        SQLCreateTableStatement sQLCreateTableStatement = (SQLCreateTableStatement)sQLStatement;
        String string = StringUtils.remove((String)sQLCreateTableStatement.getTableName(), (String)"`");
        if (list.contains(string)) {
            throw new RuntimeException("Table already exists\uff1a" + string);
        }
    }

    public void a(SQLStatement sQLStatement) {
        if (!(sQLStatement instanceof SQLCreateIndexStatement)) {
            return;
        }
        SQLCreateIndexStatement sQLCreateIndexStatement = (SQLCreateIndexStatement)sQLStatement;
        String string = StringUtils.remove((String)sQLCreateIndexStatement.getTableName(), (String)"`");
        String string2 = StringUtils.remove((String)sQLCreateIndexStatement.getIndexDefinition().getName().getSimpleName(), (String)"`");
        List list = this.tL.getTableIndexList(string).stream().map(map -> String.valueOf(map.getOrDefault("Key_name", map.get("KEY_NAME")))).collect(Collectors.toList());
        if (list.contains(string2)) {
            throw new RuntimeException("Table index already exists\uff1a" + string + "." + string2);
        }
    }

    public void b(SQLStatement sQLStatement) {
        if (!(sQLStatement instanceof SQLAlterTableStatement)) {
            return;
        }
        SQLAlterTableStatement sQLAlterTableStatement = (SQLAlterTableStatement)sQLStatement;
        String string = StringUtils.remove((String)sQLAlterTableStatement.getTableName(), (String)"`");
        List list = this.tL.getTableColumnList(string).stream().map(map -> String.valueOf(map.getOrDefault("Field", map.get("FIELD")))).collect(Collectors.toList());
        List list2 = this.tL.getTableIndexList(string).stream().map(map -> String.valueOf(map.getOrDefault("Key_name", map.get("KEY_NAME")))).collect(Collectors.toList());
        for (SQLAlterTableItem sQLAlterTableItem : sQLAlterTableStatement.getItems()) {
            Object object;
            SQLAlterTableAddColumn sQLAlterTableAddColumn;
            if (sQLAlterTableItem instanceof SQLAlterTableAddColumn) {
                sQLAlterTableAddColumn = (SQLAlterTableAddColumn)sQLAlterTableItem;
                object = sQLAlterTableAddColumn.getColumns().iterator();
                while (object.hasNext()) {
                    SQLColumnDefinition sQLColumnDefinition = (SQLColumnDefinition)object.next();
                    String string2 = StringUtils.remove((String)sQLColumnDefinition.getColumnName(), (String)"`");
                    if (!list.contains(string2)) continue;
                    throw new RuntimeException("Field already exists\uff1a" + string + "." + string2);
                }
                continue;
            }
            if (!(sQLAlterTableItem instanceof SQLAlterTableAddIndex) || !list2.contains(object = StringUtils.remove((String)(sQLAlterTableAddColumn = (SQLAlterTableAddIndex)sQLAlterTableItem).getIndexDefinition().getName().getSimpleName(), (String)"`"))) continue;
            throw new RuntimeException("Table index already exists\uff1a" + string + "." + (String)object);
        }
    }

    private String W(String string) {
        ClassPathResource classPathResource = new ClassPathResource(string);
        if (!classPathResource.exists()) {
            return null;
        }
        try {
            byte[] byArray = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            return new String(byArray, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

