/*
 * Decompiled with CFR 0.152.
 */
package com.zyplayer.doc.x.fz;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.zyplayer.doc.data.repository.manage.entity.WikiPage;
import com.zyplayer.doc.data.repository.manage.entity.WikiSpace;
import com.zyplayer.doc.data.repository.manage.mapper.WikiPageMapper;
import com.zyplayer.doc.x.f.a;
import com.zyplayer.doc.x.fz.d;
import com.zyplayer.doc.x.gg.aj;
import com.zyplayer.doc.x.gg.aw;
import com.zyplayer.doc.x.gp.z;
import com.zyplayer.doc.x.gs.b;
import com.zyplayer.doc.x.gs.f;
import com.zyplayer.doc.x.gs.i;
import com.zyplayer.doc.x.gz.k;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class c {
    private static Logger logger = LoggerFactory.getLogger(c.class);
    @Resource
    WikiPageMapper wikiPageMapper;
    @Resource
    aw wikiSpaceService;
    @Resource
    aj wikiPageContentService;
    @Resource
    d localAiSearch;

    private String createSpaceSync(Long spaceId) {
        if (this.localAiSearch.isActive()) {
            try {
                String string = this.localAiSearch.createSpace(spaceId);
                WikiSpace wikiSpace = new WikiSpace();
                wikiSpace.setId(spaceId);
                wikiSpace.setAiKbId(string);
                this.wikiSpaceService.updateById((Object)wikiSpace);
                return string;
            }
            catch (Exception exception) {
                logger.error("AI\u77e5\u8bc6\u5e93\u521b\u5efa\u5931\u8d25\uff1a{}", (Object)exception.getMessage());
            }
        }
        return null;
    }

    public void deleteSpace(String aiKbId) {
        if (this.localAiSearch.isActive() && StringUtils.isNotBlank((CharSequence)aiKbId)) {
            try {
                this.localAiSearch.deleteSpace(aiKbId);
            }
            catch (Exception exception) {
                logger.error("AI\u77e5\u8bc6\u5e93\u5220\u9664\u5931\u8d25\uff1a{}", (Object)exception.getMessage());
            }
        }
    }

    @Async
    public void uploadFile(Long pageId, String aiKbId, Integer editorType, String name, String fileExtension, byte[] fileBytes) {
        if (this.localAiSearch.isNotActive()) {
            return;
        }
        this.uploadFileSync(pageId, aiKbId, editorType, name, fileExtension, fileBytes);
    }

    private void uploadFileSync(Long pageId, String aiKbId, Integer editorType, String name, String fileExtension, byte[] fileBytes) {
        if (this.localAiSearch.isNotActive() || StringUtils.isBlank((CharSequence)aiKbId) || ArrayUtils.isEmpty((byte[])fileBytes)) {
            return;
        }
        try {
            String string = this.getFileName(editorType, name, fileExtension);
            String string2 = this.localAiSearch.uploadFile(aiKbId, string, pageId, fileBytes);
            if (string2 != null) {
                WikiPage wikiPage = new WikiPage();
                wikiPage.setId(pageId);
                wikiPage.setAiPageId(string2);
                this.wikiPageMapper.updateById((Object)wikiPage);
            }
        }
        catch (Exception exception) {
            logger.error("AI\u5185\u5bb9\u63a8\u9001\u5931\u8d25\uff1a{}", (Object)exception.getMessage());
        }
    }

    private String getFileName(Integer editorType, String name, String fileExtension) {
        String string = null;
        if (Objects.equals(editorType, 1)) {
            string = name + ".md";
        } else if (Objects.equals(editorType, 2)) {
            string = name + ".md";
        } else if (Objects.equals(editorType, 3)) {
            string = name + ".csv";
        } else if (Objects.equals(editorType, 5)) {
            string = name;
            if (!name.endsWith("." + fileExtension)) {
                string = name + "." + fileExtension;
            }
        } else if (Objects.equals(editorType, 6)) {
            string = name + ".txt";
        } else if (Objects.equals(editorType, 7)) {
            string = name + ".md";
        } else if (Objects.equals(editorType, 9)) {
            string = name + ".txt";
        }
        return string;
    }

    public com.zyplayer.doc.x.ga.f syncWholeSpaceStatus(Long spaceId) {
        com.zyplayer.doc.x.ga.f f2 = new com.zyplayer.doc.x.ga.f();
        f2.setSynchronizing(false);
        if (spaceId == null) {
            return f2;
        }
        com.zyplayer.doc.x.ga.f f3 = (com.zyplayer.doc.x.ga.f)b.get((String)("AI_SPACE_SYNC_STATUS_" + spaceId), com.zyplayer.doc.x.ga.f.class);
        if (f3 != null) {
            return f3;
        }
        WikiSpace wikiSpace = (WikiSpace)this.wikiSpaceService.getById((Serializable)spaceId);
        if (wikiSpace != null) {
            f2.setAiKbId(wikiSpace.getAiKbId());
        }
        return f2;
    }

    public synchronized a<com.zyplayer.doc.x.ga.f> syncWholeSpaceValidate(Long spaceId, boolean needCreate) {
        if (this.localAiSearch.isNotActive()) {
            return a.warn((com.zyplayer.doc.x.d.b)com.zyplayer.doc.x.d.b.AI_SERVICE_NOT_ENABLED, (Object[])new Object[0]);
        }
        com.zyplayer.doc.x.ga.f f2 = (com.zyplayer.doc.x.ga.f)b.get((String)("AI_SPACE_SYNC_STATUS_" + spaceId), com.zyplayer.doc.x.ga.f.class);
        if (f2 != null) {
            logger.error("\u5f53\u524d\u7a7a\u95f4\u6b63\u5728\u540c\u6b65\uff0c\u8bf7\u7b49\u5f85~");
            return a.warn((com.zyplayer.doc.x.d.b)com.zyplayer.doc.x.d.b.SPACE_SYNC_IN_PROGRESS, (Object[])new Object[0]);
        }
        if (needCreate) {
            com.zyplayer.doc.x.ga.f f3 = new com.zyplayer.doc.x.ga.f();
            b.put((String)("AI_SPACE_SYNC_STATUS_" + spaceId), (Object)f3);
            return a.ok((Object)f3);
        }
        return a.ok();
    }

    @Async
    public void syncWholeSpace(Long spaceId, String domainUri) {
        a a2 = this.syncWholeSpaceValidate(spaceId, true);
        if (!a2.isOk()) {
            return;
        }
        try {
            com.zyplayer.doc.x.ga.f f2 = (com.zyplayer.doc.x.ga.f)a2.getData();
            this.syncWholeSpaceSync(spaceId, domainUri, f2);
        }
        catch (Exception exception) {
            logger.error("AI\u540c\u6b65\u77e5\u8bc6\u5e93\u5931\u8d25\uff1a{}", (Object)exception.getMessage());
        }
        b.remove((String)("AI_SPACE_SYNC_STATUS_" + spaceId));
    }

    public byte[] pageContentToBytes(Integer editorType, String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return new byte[0];
        }
        if (Objects.equals(editorType, 1)) {
            content = i.htmlToMarkdown((String)content);
        }
        return content.getBytes(StandardCharsets.UTF_8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] pageOriginContentToBytes(Integer editorType, String content, String domainUri) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return new byte[0];
        }
        if (Objects.equals(editorType, 1)) {
            content = i.htmlToMarkdown((String)content);
            return content.getBytes(StandardCharsets.UTF_8);
        }
        if (!Objects.equals(editorType, 5)) return content.getBytes(StandardCharsets.UTF_8);
        z z2 = (z)JSON.parseObject((String)content, z.class);
        if (!d.allowedExtNameSet.contains(z2.getFileType())) {
            return new byte[0];
        }
        try {
            byte[] byArray = HttpUtil.downloadBytes((String)f.getFullUrl((String)z2.getUrl(), (String)domainUri));
            if (!StringUtils.equalsAnyIgnoreCase((CharSequence)z2.getFileType(), (CharSequence[])k.textFileSuffixs)) return byArray;
            if (z2.getCharset() == null) return byArray;
            return new String(byArray, z2.getCharset()).getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)exception.getMessage());
            return new byte[0];
        }
    }

    private void syncWholeSpaceSync(Long spaceId, String domainUri, com.zyplayer.doc.x.ga.f syncStatus) {
        String string;
        if (this.localAiSearch.isNotActive()) {
            return;
        }
        WikiSpace wikiSpace = (WikiSpace)this.wikiSpaceService.getById((Serializable)spaceId);
        if (StringUtils.isNotBlank((CharSequence)wikiSpace.getAiKbId())) {
            try {
                this.localAiSearch.deleteSpace(wikiSpace.getAiKbId());
            }
            catch (Exception exception) {
                logger.error("AI\u77e5\u8bc6\u5e93\u5220\u9664\u5931\u8d25\uff1a{}", (Object)exception.getMessage());
            }
        }
        if ((string = this.createSpaceSync(spaceId)) == null) {
            return;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(WikiPage::getDelFlag, (Object)0);
        lambdaQueryWrapper.eq(WikiPage::getSpaceId, (Object)spaceId);
        lambdaQueryWrapper.in(WikiPage::getEditorType, new Object[]{1, 2, 3, 5, 6, 7, 9});
        lambdaQueryWrapper.select((Object[])new SFunction[]{WikiPage::getId, WikiPage::getSpaceId, WikiPage::getEditorType, WikiPage::getFileExtension, WikiPage::getUuid, WikiPage::getName});
        List list = this.wikiPageMapper.selectList((Wrapper)lambdaQueryWrapper);
        syncStatus.setPageNum(list.size());
        for (WikiPage wikiPage : list) {
            try {
                String string2 = this.wikiPageContentService.d(wikiPage.getSpaceId(), wikiPage.getId(), wikiPage.getEditorType());
                if (StringUtils.isNotBlank((CharSequence)string2)) {
                    byte[] byArray = this.pageOriginContentToBytes(wikiPage.getEditorType(), string2, domainUri);
                    this.uploadFileSync(wikiPage.getId(), string, wikiPage.getEditorType(), wikiPage.getName(), wikiPage.getFileExtension(), byArray);
                }
            }
            catch (Exception exception) {
                logger.error("AI\u5185\u5bb9\u63a8\u9001\u5f02\u5e38\uff1a{}", (Object)exception.getMessage());
            }
            syncStatus.addNum();
        }
    }
}

